% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotationFilters.R
\docType{class}
\name{Filter-classes}
\alias{Filter-classes}
\alias{CompoundIdFilter-class}
\alias{CompoundIdFilter}
\alias{SpectrumIdFilter-class}
\alias{SpectrumIdFilter}
\alias{NameFilter-class}
\alias{NameFilter}
\alias{MsmsMzRangeMinFilter-class}
\alias{MsmsMzRangeMinFilter}
\alias{MsmsMzRangeMaxFilter-class}
\alias{MsmsMzRangeMaxFilter}
\alias{ExactmassFilter-class}
\alias{ExactmassFilter}
\alias{FormulaFilter-class}
\alias{FormulaFilter}
\alias{InchiFilter-class}
\alias{InchiFilter}
\alias{InchikeyFilter-class}
\alias{InchikeyFilter}
\alias{IonIdFilter-class}
\alias{IonIdFilter}
\alias{IonAdductFilter-class}
\alias{IonAdductFilter}
\alias{IonMzFilter-class}
\alias{IonMzFilter}
\alias{IonRtFilter-class}
\alias{IonRtFilter}
\title{Filters supported by CompDb and IonDb}
\usage{
CompoundIdFilter(value, condition = "==")

SpectrumIdFilter(value, condition = "==")

NameFilter(value, condition = "==")

MsmsMzRangeMinFilter(value, condition = ">=")

MsmsMzRangeMaxFilter(value, condition = "<=")

ExactmassFilter(value, condition = "==")

FormulaFilter(value, condition = "==")

InchiFilter(value, condition = "==")

InchikeyFilter(value, condition = "==")

IonIdFilter(value, condition = "==")

IonAdductFilter(value, condition = "==")

IonMzFilter(value, condition = "==")

IonRtFilter(value, condition = "==")
}
\arguments{
\item{value}{The value for the filter. For details see
\code{\link[AnnotationFilter:AnnotationFilter]{AnnotationFilter::AnnotationFilter()}}.}

\item{condition}{The condition for the filter. For details see
\code{\link[AnnotationFilter:AnnotationFilter]{AnnotationFilter::AnnotationFilter()}}.}
}
\value{
Constructor functions return an instance of the respective class.
}
\description{
A variety of different filters can be applied to the \code{CompDb} object to
retrieve only subsets of the data. These filters extend the
\link[AnnotationFilter:AnnotationFilter]{AnnotationFilter::AnnotationFilter} class and support the filtering concepts
introduced by Bioconductor's \code{AnnotationFilter} package.

The supported filters are:
\itemize{
\item \code{CompoundIdFilter}: filter based on the compound ID.
\item \code{FormulaFilter}: filter based on the compound's formula.
\item \code{InchiFilter}: filter based on the compound's InChI.
\item \code{InchikeyFilter}: filter based on the compound's InChI key.
\item \code{ExactmassFilter}: filter based on the compound's (exact) mass.
\item \code{NameFilter}: filter based on the compound name.
\item \code{MsmsMzRangeMinFilter}: retrieve entries based on the smallest m/z of all
peaks of their MS/MS spectra. Requires that MS/MS spectra data are present
(i.e. \code{hasMsMsSpectra(cmp_db)} returns \code{TRUE}).
\item \code{MsmsMzRangeMaxFilter}: retrieve entries based on the largest m/z of all
peaks of their MS/MS spectra. Requires that MS/MS spectra data are present
(i.e. \code{hasMsMsSpectra(cmp_db)} returns \code{TRUE}).
\item \code{SpectrumIdFilter}: retrieve entries associated with the provided IDs of
MS/MS spectra.
}

In addition to the filters listed above, the following ones are supported by
a IonDb (but not by a CompDb):
\itemize{
\item \code{IonIdFilter}: filter based on the ion ID.
\item \code{IonAdductFilter}: filter based on the adduct.
\item \code{IonMzFilter}: filter based on the mz of the ion.
\item \code{IonRtFilter}: filter based on the rt of the ion.
}
}
\examples{
## Create a filter for the compound id
cf <- CompoundIdFilter("comp_a")
cf

## Create a filter using a formula expression
AnnotationFilter(~ compound_id == "comp_b")

## Combine filters
AnnotationFilterList(CompoundIdFilter("a"), NameFilter("b"))

## Using a formula expression
AnnotationFilter(~ compound_id == "a" | name != "b")
}
\seealso{
\code{\link[AnnotationFilter:AnnotationFilter]{AnnotationFilter::supportedFilters()}} for the method to list all
supported filters for a \code{CompDb} (or a IonDb) object.
}
\author{
Johannes Rainer
}
