% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum-import-functions.R
\name{msms_spectra_mona}
\alias{msms_spectra_mona}
\title{Import MS/MS spectra from MoNa}
\usage{
msms_spectra_mona(x, collapsed = TRUE)
}
\arguments{
\item{x}{\code{character(1)}: with the path to directory containing the xml files.}

\item{collapsed}{\code{logical(1)} whether the returned \code{data.frame} should be
\emph{collapsed} or \emph{expanded}. See description for more details.}
}
\value{
\code{data.frame} with as many rows as there are peaks and columns:
\itemize{
\item spectrum_id (\code{integer}): an arbitrary, unique ID for each spectrum.
\item original_spectrum_id (\code{character}): The ID from the spectrum as specified
in the MoNa SDF.
\item compound_id (\code{character}): the compound ID the spectrum is associated
with.
\item polarity (\code{integer}): 0 for negative, 1 for positive, \code{NA} for not set.
\item collision_energy (\code{character}): collision energy voltage.
\item predicted (\code{logical}): whether the spectrum is predicted or experimentally
verified.
\item splash (\code{character}): \code{NA} since SPLASH (SPectraL hASH) keys are not
provided.
\item instrument_type (\code{character}): the type of MS instrument on which the
spectrum was measured.
\item instrument (\code{character}): the MS instrument.
\item precursor_mz (\code{numeric}): precursor m/z.
\item adduct (\code{character}): ion formed from the precursor ion.
\item ms_level (\code{integer}): stage of the sequential mass spectrometry (MSn).
\item mz (\code{numeric} or \code{list} of \code{numeric}): m/z values of the spectrum.
\item intensity (\code{numeric} or \code{list} of \code{numeric}): intensity of the spectrum.
}
}
\description{
\code{msms_spectra_mona()} imports MS/MS spectra from a MoNa (Massbank of North
America, http://mona.fiehnlab.ucdavis.edu/downloads) SDF file and returns
the data as a \code{data.frame}.

Depending on the parameter \code{collapsed}, the returned \code{data.frame} is either
\emph{collapsed}, meaning that each row represents data from one spectrum,
or \emph{expanded} with one row for each m/z and intensity pair for each
spectrum. Columns \code{"mz"} and \code{"intensity"} are of type \code{list} for
\code{collapsed = TRUE} and \code{numeric} for \code{collapsed = FALSE}.
}
\note{
The identifiers provided by MoNa are used as \emph{original_spectrum_id}. Note
also that the MoNa data is not normalized in the sense that each spectrum is
associated to one compound and the compound data is partially redundant.
Also, MoNa does not provide a \emph{splash} for a spectrum, hence the
corresponding column will only contain \code{NA}.
}
\examples{

## Define the test file containing the data
fl <- system.file("sdf/MoNa_export-All_Spectra_sub.sdf.gz",
    package = "CompoundDb")
## Import spectrum data from the SDF file with a subset of the MoNa data
msms_spectra_mona(fl)

## Import the data as an *expanded* data frame, i.e. with a row for each
## single m/z (intensity) value.
msms_spectra_mona(fl, collapsed = FALSE)
}
\seealso{
\code{\link[=createCompDb]{createCompDb()}} for the function to create a \link{CompDb} database with
compound annotation and spectrum data.

Other spectrum data import functions.: 
\code{\link{msms_spectra_hmdb}()}
}
\author{
Johannes Rainer
}
\concept{spectrum data import functions.}
