% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotDotSSI.R
\name{PlotDotSSI}
\alias{PlotDotSSI}
\title{Plot dot plot of Secondary Stain Index scores}
\usage{
PlotDotSSI(output, og, primary, secondary, showScores = TRUE)
}
\arguments{
\item{output}{(matrix): Matrix containing the SSI output from the CompensAID tool.}

\item{og}{(flowFrame): FlowFrame containing the expression matrix, channel names, and marker names.}

\item{primary}{(character): Primary marker (x-axis)}

\item{secondary}{(character): Seconday marker (y-axis)}

\item{showScores}{(boolean): Boolean variable determining if scores and gating should be visualized.}
}
\value{
(ggplot2) Returns figure containing a dot plot of the CompensAID output.
}
\description{
This function plots the marker combinations of interest. Additionally, the gating, segmentation, and SSI values can be visualized by setting showScore to TRUE.
}
\examples{
# Import FCS file
file <- flowCore::read.FCS(system.file("extdata", "68983.fcs", package = "CompensAID"))

# Run compensAID tool
compensAID.res <- CompensAID(ff = file)

# Marker names
primary.marker <- "CD19"
secondary.marker <- "CD3"

# Plot matrix
figure <- PlotDotSSI(output = compensAID.res,
                     og = file,
                     primary = primary.marker,
                     secondary = secondary.marker,
                     showScores = TRUE)
plot(figure)

}
\seealso{
\code{\link{CompensAID}}
}
