% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protImportForAnalysis.R
\name{protImportForAnalysis}
\alias{protImportForAnalysis}
\title{Modify import protein data}
\usage{
protImportForAnalysis(inputFile)
}
\arguments{
\item{inputFile}{- character vector containing the location of protein file}
}
\value{
data frame
}
\description{
This function converts imported protien table into format compatible with 
downstream analysis
Imported file needs to contain following columns:
\itemize{
\item "Protein Group Accessions" - character/factor
\item "Protein Descriptions" - character
\item "scenario" - character/factor
\item "label" - logical
\item  columns "1" to "n" - numeric
}
}
\examples{

##Use example normalised proteins file
inputFile <- system.file("extData", "dataNormProts.txt", package = "ComPrAn")
#read file in and change structure of table to required format
forAnalysis <- protImportForAnalysis(inputFile)

}
