% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoSIA-getConversion-method.R
\name{getConversion,CoSIAn-method}
\alias{getConversion,CoSIAn-method}
\title{getConversion Method}
\usage{
\S4method{getConversion}{CoSIAn}(object)
}
\arguments{
\item{object}{CoSIAn object with all user accessible slots filled}
}
\value{
CoSIAn object with converted_id slot filled
}
\description{
getConversion Method
}
\examples{
Kidney_Genes <- CoSIAn(
    gene_set = c("ENSG00000008710", "ENSG00000118762", "ENSG00000152217"),
    i_species = "h_sapiens", input_id = "Ensembl_id",
    o_species = c(
        "d_melanogaster", "m_musculus", "h_sapiens", "d_rerio",
        "c_elegans", "r_norvegicus"
    ),
    output_ids = c("Ensembl_id", "Symbol"), mapping_tool = "annotationDBI",
    ortholog_database = "HomoloGene", map_tissues = "heart",
    map_species = c("m_musculus"), metric_type = "DS_Gene"
)
Kidney_gene_conversion <- CoSIA::getConversion(Kidney_Genes)
}
