/*
 * Please do not edit this file -- it ensures that your package will export a
 * 'run_testthat_tests()' C routine that can be used to run the Catch unit tests
 * available in your package.
 */
//AF-I edited this and run_testthat_tests() is still callable from R by:
//.Call("run_testthat_tests",PACKAGE = "REVA",TRUE)

#include <string>
#include <iostream>
#include <Rcpp.h>
#define TESTTHAT_TEST_RUNNER
#include <testthat.h>

// [[Rcpp::export]]
int run_catch_unit_tests(Rcpp::String reporter="console")
{
  Catch::Session& session = testthat::catchSession();
  Catch::ConfigData cfg;
  //we will use it to write to config as
  //session.useConfigData(cfg);
  session.configData().testsOrTags.clear();
  //resetting reporterNames
  //catch2 has reporterName rather than reporterNames,
  //here we are inside catch
  session.configData().reporterNames.clear();
  //and write "console" there;
  //catch 2 would require, but we are in catch
  //write reporter
  cfg.reporterNames.push_back(reporter);
  session.useConfigData(cfg);
  //the next line does not work here.. actually, works only one time
  //session.configData().reporterNames.push_back(reporter);
  int numFailed = session.run();
  return (numFailed < 0xFF ? numFailed : 0xFF);
}

// [[Rcpp::export]]
int run_catch_unit_tests_by_tag(Rcpp::String tag="",Rcpp::String reporter="console")
{
  Catch::Session& session = testthat::catchSession();
  Catch::ConfigData cfg;
  //we will use it to write to config as
  //session.useConfigData(cfg);
  //empty testsOrTags
  session.configData().testsOrTags.clear();
  //add new tag [tag]
  //session.configData().testsOrTags.push_back(tag.get_cstring());
  cfg.testsOrTags.push_back(tag.get_cstring());
  //empty reporternames
  session.configData().reporterNames.clear();
  //and write "console" there
  //session.configData().reporterNames.push_back("console");
  cfg.reporterNames.push_back(reporter);
  session.useConfigData(cfg);
  int numFailed = session.run();
  return (numFailed < 0xFF ? numFailed : 0xFF);
}
