% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-CogapsParams.R, R/methods-CogapsParams.R
\docType{methods}
\name{setFixedPatterns}
\alias{setFixedPatterns}
\alias{setFixedPatterns,CogapsParams-method}
\title{set the fixed patterns for either the A or the P matrix}
\usage{
setFixedPatterns(object, fixedPatterns, whichMatrixFixed)

\S4method{setFixedPatterns}{CogapsParams}(object, fixedPatterns, whichMatrixFixed)
}
\arguments{
\item{object}{an object of type CogapsParams}

\item{fixedPatterns}{values for either the A or P matrix}

\item{whichMatrixFixed}{either 'A' or 'P' indicating which matrix is fixed}
}
\value{
the modified params object
}
\description{
these parameters are interrelated so they must be set together
}
\examples{
params <- new("CogapsParams", nPatterns=3)
data(GIST)
params <- setFixedPatterns(params, getSampleFactors(GIST.result), 'P')
}
