% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_cluster_fold_change.r
\name{pairwiseClusterFoldChange}
\alias{pairwiseClusterFoldChange}
\title{Calculate the gene mean expression Fold Change between all possible combinations of clusters.}
\usage{
pairwiseClusterFoldChange(countData, clusters, nSubsampling, functToApply)
}
\arguments{
\item{countData}{Matrix. Normalized counts containing gene expression.}

\item{clusters}{Factor. A vector of corresponding cluster for each sample of (x).}

\item{nSubsampling}{Numeric. Number of random sampling of cells to achieve fold change stability.}
}
\value{
A list of dataframes containing the pairwise fold changes between all combinations of cluster.
}
\description{
`pairwiseClusterFoldChange()` returns a list of dataframes containing the pairwise fold changes between all combinations of cluster.
}
\details{
This function will perform fold change estimation from the mean feature´s expression between all possible combination of clusters specified on colLabels inside the sc object.
Bayesian Estimation of FoldChanges and Pseudocounts adapted from:
Florian Erhard, Estimating pseudocounts and fold changes for digital expression measurements, Bioinformatics, 
  Volume 34, Issue 23, December 2018, Pages 4054–4063, https://doi.org/10.1093/bioinformatics/bty471
Please consider citing also Erhard et. al. paper when using ClusterFoldSimilarity.
}
\author{
Oscar Gonzalez-Velasco
}
\keyword{internal}
