\name{get_beta_violin}
\alias{get_beta_violin}
\title{Visualize distribution of \eqn{\beta} means in each repertoire 
as violin plots}
\description{
Visualize the \eqn{\beta} means as violin plots, representing relative 
community occupancies for individual repertoires. At the same time, annotate 
the communities (dots) based on their specificity.
}
\details{
The user has to provide an antigen species (e.g. \code{ag} = "EBV" 
and \code{ag_species}=TRUE) or an antigen gene (e.g. \code{ag} = "MLANA" 
and \code{ag_species}=FALSE). Furthermore, the user has to provide 
nodes (\code{node_summary} data.frame created by the function 
\code{detect_communities}) and \code{beta} data.frame which is part of 
\code{posterior_summary} generated by the function \code{dco}. 

The user can also select an annotation database \code{db},
such as "vdjdb", "mcpas" or "tcr3d". We will look for perfect matches between 
CDR3 sequences in the input and in the annotation database for annotation.
}
\usage{
get_beta_violin(beta,
                 node_summary,
                 ag,
                 ag_species,
                 db = "vdjdb")
}
\arguments{
\item{beta}{\code{beta} data.frame}
\item{node_summary}{\code{node_summary} data.frame}
\item{ag}{antigen species/gene, character, e.g. "EBV", "CMV", or "MLANA"}
\item{ag_species}{is the antigen a species (TRUE) or gene (FALSE)}
\item{db}{annotation database, character, e.g. "vdjdb"}
}
\value{
The output is a violin ggplot.

}
\examples{
# load package input data
data("CDR3ab", package = "ClustIRR")
a <- data.frame(CDR3a = CDR3ab[1:500, "CDR3a"],
                  CDR3b = CDR3ab[1:500, "CDR3b"],
                  clone_size = 1,
                  sample = "a")

b <- data.frame(CDR3a = CDR3ab[401:900, "CDR3a"],
                  CDR3b = CDR3ab[401:900, "CDR3b"],
                  clone_size = 1,
                  sample = "b")
b$clone_size[1] <- 20

# run ClustIRR analysis
c <- clustirr(s = rbind(a, b))

# detect communities
gcd <- detect_communities(graph = c$graph, 
                          algorithm = "leiden",
                          resolution = 1,
                          weight = "ncweight",
                          chains = c("CDR3a", "CDR3b"))

# differential community occupancy analysis
dco <- dco(community_occupancy_matrix = gcd$community_occupancy_matrix)

# generate beta violin plots
v <- get_beta_violin(beta = dco$posterior_summary$beta,
                     node_summary = gcd$node_summary,
                     ag = "EBV",
                     ag_species = TRUE,
                     db = "vdjdb")
}
