\name{clust_irr-class}
\docType{class}
\alias{clust_irr}
\alias{class:clust_irr}
\alias{clust_irr-class}

% Accessor methods:
\alias{get_clustirr_clust,clust_irr-method}
\alias{get_clustirr_inputs,clust_irr-method}
\alias{get_clustirr_clust}
\alias{get_clustirr_inputs}

\title{clust_irr class}

\arguments{
\item{clust}{list, contains clustering results for each TCR/BCR chain. The
results are stored in separate sub-list named appropriately (e.g. CDR3a, CDR3b, 
CDR3g, etc.)}
\item{inputs}{list, contains all user provided inputs}
}

\description{
Objects of the class \code{clust_irr} are generated by the function 
\code{cluster_irr}. These objects are used to store the clustering results 
in a structured way, such that they may be used as inputs of other ClustIRR 
functions (e.g. get_graph, plot_graph, etc.). 

The output is an \code{S4} object of class \code{clust_irr}. This object 
contains two sublists:
\itemize{
\item{\code{clust}, list, contains clustering results for each IR chain. 
The results are stored as data.frame in separate sub-list named appropriately 
(e.g. CDR3a, CDR3b, CDR3g, etc.). Each row in the data.frames contains a pair 
of CDR3s.

The remaining columns contain similarity scores for the complete CDR3 sequences 
(column \code{weight}) or their cores (column \code{cweight}). The columns 
\code{max_len} and \code{max_clen} store the length of the longer CDR3 and 
CDR3 core sequence in the pair, and these used to normalize the scores 
\code{weight} and \code{cweight}: the normalized scores are shown in the 
columns \code{nweight} and \code{ncweight}}

\item{\code{inputs}, list, contains all user provided inputs (see Arguments)}
}
}

\section{Accessors}{
To access the slots of \code{clust_irr} object we have two accessor 
functions. In the description below, \code{x} is a \code{clust_irr} 
object.

\describe{
\item{get_clustirr_clust}{
\code{get_clustirr_clust(x)}:
Extract the clustering results (slot clust)
}
\item{get_clustirr_inputs}{
\code{get_clustirr_inputs(x)}:
Extract the processed inputs (slot inputs)
}
}
}

\value{
The output is an S4 object of class \code{clust_irr}
}

\examples{
# load package input data
data("CDR3ab", package = "ClustIRR")
s <- data.frame(CDR3b = CDR3ab[1:100, "CDR3b"], sample = "A", clone_size = 1)

# run analysis
c <- clustirr(s = s)

# output class
class(c)

# output structure
str(c)

# inspect which CDR3bs are globally similar
knitr::kable(head(slot(c$clust_irrs, "clust")$CDR3b))


# clust_irr S4 object generated 'manually' from the individual results
new_clust_irr <- new("clust_irr", 
                     clust = slot(object = c$clust_irrs, name = "clust"),
                     inputs = slot(object = c$clust_irrs, name = "inputs"))

# we should get identical outputs
identical(x = new_clust_irr, y = c$clust_irrs)
}
