// Generated by rstantools.  Do not edit by hand.

/*
    ClustIRR is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    ClustIRR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ClustIRR.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_dmh_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 76> locations_array__ =
  {" (found before start of program)",
  " (in 'dmh', line 27, column 4 to column 25)",
  " (in 'dmh', line 28, column 4 to column 21)",
  " (in 'dmh', line 29, column 4 to column 32)",
  " (in 'dmh', line 30, column 4 to column 41)",
  " (in 'dmh', line 31, column 4 to column 26)",
  " (in 'dmh', line 34, column 4 to column 24)",
  " (in 'dmh', line 52, column 4 to column 21)",
  " (in 'dmh', line 53, column 4 to column 21)",
  " (in 'dmh', line 54, column 4 to column 22)",
  " (in 'dmh', line 55, column 4 to column 37)",
  " (in 'dmh', line 56, column 4 to column 39)",
  " (in 'dmh', line 57, column 4 to column 14)",
  " (in 'dmh', line 36, column 8 to column 63)",
  " (in 'dmh', line 35, column 18 to line 37, column 5)",
  " (in 'dmh', line 35, column 4 to line 37, column 5)",
  " (in 'dmh', line 60, column 8 to column 61)",
  " (in 'dmh', line 61, column 8 to column 52)",
  " (in 'dmh', line 62, column 8 to column 66)",
  " (in 'dmh', line 59, column 18 to line 63, column 5)",
  " (in 'dmh', line 59, column 4 to line 63, column 5)",
  " (in 'dmh', line 68, column 16 to column 51)",
  " (in 'dmh', line 69, column 16 to column 77)",
  " (in 'dmh', line 70, column 16 to column 23)",
  " (in 'dmh', line 67, column 35 to line 71, column 13)",
  " (in 'dmh', line 67, column 12 to line 71, column 13)",
  " (in 'dmh', line 66, column 27 to line 72, column 9)",
  " (in 'dmh', line 66, column 8 to line 72, column 9)",
  " (in 'dmh', line 65, column 25 to line 73, column 5)",
  " (in 'dmh', line 65, column 4 to line 73, column 5)",
  " (in 'dmh', line 40, column 4 to column 43)",
  " (in 'dmh', line 41, column 4 to column 45)",
  " (in 'dmh', line 42, column 4 to column 37)",
  " (in 'dmh', line 44, column 8 to column 47)",
  " (in 'dmh', line 43, column 23 to line 45, column 5)",
  " (in 'dmh', line 43, column 4 to line 45, column 5)",
  " (in 'dmh', line 47, column 8 to column 45)",
  " (in 'dmh', line 48, column 8 to column 63)",
  " (in 'dmh', line 46, column 18 to line 49, column 5)",
  " (in 'dmh', line 46, column 4 to line 49, column 5)",
  " (in 'dmh', line 10, column 4 to column 10)",
  " (in 'dmh', line 11, column 4 to column 10)",
  " (in 'dmh', line 12, column 21 to column 22)",
  " (in 'dmh', line 12, column 4 to column 24)",
  " (in 'dmh', line 13, column 11 to column 12)",
  " (in 'dmh', line 13, column 14 to column 15)",
  " (in 'dmh', line 13, column 4 to column 17)",
  " (in 'dmh', line 14, column 4 to column 40)",
  " (in 'dmh', line 17, column 4 to column 16)",
  " (in 'dmh', line 18, column 4 to column 16)",
  " (in 'dmh', line 19, column 4 to column 16)",
  " (in 'dmh', line 20, column 4 to column 16)",
  " (in 'dmh', line 22, column 8 to column 20)",
  " (in 'dmh', line 23, column 8 to column 38)",
  " (in 'dmh', line 21, column 25 to line 24, column 5)",
  " (in 'dmh', line 21, column 4 to line 24, column 5)",
  " (in 'dmh', line 28, column 12 to column 13)",
  " (in 'dmh', line 29, column 24 to column 30)",
  " (in 'dmh', line 29, column 12 to column 13)",
  " (in 'dmh', line 30, column 22 to column 28)",
  " (in 'dmh', line 31, column 23 to column 24)",
  " (in 'dmh', line 31, column 12 to column 13)",
  " (in 'dmh', line 34, column 21 to column 22)",
  " (in 'dmh', line 34, column 12 to column 13)",
  " (in 'dmh', line 52, column 15 to column 16)",
  " (in 'dmh', line 52, column 18 to column 19)",
  " (in 'dmh', line 53, column 18 to column 19)",
  " (in 'dmh', line 54, column 19 to column 20)",
  " (in 'dmh', line 54, column 13 to column 14)",
  " (in 'dmh', line 55, column 28 to column 35)",
  " (in 'dmh', line 55, column 12 to column 19)",
  " (in 'dmh', line 56, column 30 to column 37)",
  " (in 'dmh', line 56, column 12 to column 19)",
  " (in 'dmh', line 3, column 8 to column 36)",
  " (in 'dmh', line 4, column 8 to line 6, column 65)",
  " (in 'dmh', line 2, column 40 to line 7, column 5)"};
template <bool propto__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>* = nullptr>
stan::promote_args_t<stan::base_type_t<T1__>>
dm_lpmf(const std::vector<int>& y, const T1__& alpha_arg__, std::ostream*
        pstream__);
template <bool propto__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>*>
stan::promote_args_t<stan::base_type_t<T1__>>
dm_lpmf(const std::vector<int>& y, const T1__& alpha_arg__, std::ostream*
        pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T1__>>;
  int current_statement__ = 0;
  const auto& alpha = stan::math::to_ref(alpha_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ sum_alpha = DUMMY_VAR__;
    current_statement__ = 73;
    sum_alpha = stan::math::sum(alpha);
    current_statement__ = 74;
    return (((((stan::math::lgamma(sum_alpha) -
           stan::math::lgamma((stan::math::sum(y) + sum_alpha))) +
           stan::math::lgamma((stan::math::sum(y) + 1))) -
           stan::math::sum(
             stan::math::lgamma(stan::math::add(stan::math::to_vector(y), 1))))
           +
           stan::math::sum(
             stan::math::lgamma(
               stan::math::add(stan::math::to_vector(y), alpha))))
           - stan::math::sum(stan::math::lgamma(alpha)));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_dmh final : public model_base_crtp<model_dmh> {
private:
  int K;
  int N;
  std::vector<int> G;
  std::vector<std::vector<int>> y;
  int compute_delta;
  int N_delta;
  int K_delta;
  int beta_mu_1dim__;
  int beta_sigma_1dim__;
public:
  ~model_dmh() {}
  model_dmh(stan::io::var_context& context__, unsigned int random_seed__ = 0,
            std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_dmh_namespace::model_dmh";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 40;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{});
      K = std::numeric_limits<int>::min();
      current_statement__ = 40;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 41;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 41;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 42;
      stan::math::validate_non_negative_index("G", "N", N);
      current_statement__ = 43;
      context__.validate_dims("data initialization", "G", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      G = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 43;
      G = context__.vals_i("G");
      current_statement__ = 43;
      stan::math::check_greater_or_equal(function__, "G", G, 1);
      current_statement__ = 44;
      stan::math::validate_non_negative_index("y", "N", N);
      current_statement__ = 45;
      stan::math::validate_non_negative_index("y", "K", K);
      current_statement__ = 46;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K)});
      y = std::vector<std::vector<int>>(N,
            std::vector<int>(K, std::numeric_limits<int>::min()));
      {
        std::vector<int> y_flat__;
        current_statement__ = 46;
        y_flat__ = context__.vals_i("y");
        current_statement__ = 46;
        pos__ = 1;
        current_statement__ = 46;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 46;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 46;
            stan::model::assign(y, y_flat__[(pos__ - 1)],
              "assigning variable y", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 46;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 47;
      context__.validate_dims("data initialization", "compute_delta", "int",
        std::vector<size_t>{});
      compute_delta = std::numeric_limits<int>::min();
      current_statement__ = 47;
      compute_delta = context__.vals_i("compute_delta")[(1 - 1)];
      current_statement__ = 47;
      stan::math::check_greater_or_equal(function__, "compute_delta",
        compute_delta, 0);
      current_statement__ = 47;
      stan::math::check_less_or_equal(function__, "compute_delta",
        compute_delta, 1);
      current_statement__ = 48;
      N_delta = std::numeric_limits<int>::min();
      current_statement__ = 49;
      K_delta = std::numeric_limits<int>::min();
      current_statement__ = 50;
      K_delta = 0;
      current_statement__ = 51;
      N_delta = 0;
      current_statement__ = 55;
      if (stan::math::logical_eq(compute_delta, 1)) {
        current_statement__ = 52;
        K_delta = K;
        current_statement__ = 53;
        N_delta = ((stan::math::max(G) * (stan::math::max(G) - 1)) / 2);
      }
      current_statement__ = 56;
      stan::math::validate_non_negative_index("alpha", "K", K);
      current_statement__ = 57;
      beta_mu_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 57;
      beta_mu_1dim__ = stan::math::max(G);
      current_statement__ = 57;
      stan::math::validate_non_negative_index("beta_mu", "max(G)",
        beta_mu_1dim__);
      current_statement__ = 58;
      stan::math::validate_non_negative_index("beta_mu", "K", K);
      current_statement__ = 59;
      beta_sigma_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 59;
      beta_sigma_1dim__ = stan::math::max(G);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("beta_sigma", "max(G)",
        beta_sigma_1dim__);
      current_statement__ = 60;
      stan::math::validate_non_negative_index("beta_z", "N", N);
      current_statement__ = 61;
      stan::math::validate_non_negative_index("beta_z", "K", K);
      current_statement__ = 62;
      stan::math::validate_non_negative_index("beta", "N", N);
      current_statement__ = 63;
      stan::math::validate_non_negative_index("beta", "K", K);
      current_statement__ = 64;
      stan::math::validate_non_negative_index("y_hat", "N", N);
      current_statement__ = 65;
      stan::math::validate_non_negative_index("y_hat", "K", K);
      current_statement__ = 66;
      stan::math::validate_non_negative_index("log_lik", "N", N);
      current_statement__ = 67;
      stan::math::validate_non_negative_index("p", "N", N);
      current_statement__ = 68;
      stan::math::validate_non_negative_index("p", "K", K);
      current_statement__ = 69;
      stan::math::validate_non_negative_index("delta", "N_delta", N_delta);
      current_statement__ = 70;
      stan::math::validate_non_negative_index("delta", "K_delta", K_delta);
      current_statement__ = 71;
      stan::math::validate_non_negative_index("epsilon", "N_delta", N_delta);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("epsilon", "K_delta", K_delta);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + K + (beta_mu_1dim__ * K) + beta_sigma_1dim__ + (N *
      K);
  }
  inline std::string model_name() const final {
    return "model_dmh";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ = "model_dmh_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ kappa = DUMMY_VAR__;
      current_statement__ = 1;
      kappa = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 2;
      alpha = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> beta_mu =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(beta_mu_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__));
      current_statement__ = 3;
      beta_mu = in__.template read<
                  std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>>(beta_mu_1dim__,
                  K);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_sigma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(beta_sigma_1dim__,
          DUMMY_VAR__);
      current_statement__ = 4;
      beta_sigma = in__.template read_constrain_lb<
                     Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0,
                     lp__, beta_sigma_1dim__);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> beta_z =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__));
      current_statement__ = 5;
      beta_z = in__.template read<
                 std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>>(N, K);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> beta =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__));
      current_statement__ = 15;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 13;
        stan::model::assign(beta,
          stan::math::add(
            stan::model::rvalue(beta_mu, "beta_mu",
              stan::model::index_uni(
                stan::model::rvalue(G, "G", stan::model::index_uni(i)))),
            stan::math::multiply(
              stan::model::rvalue(beta_sigma, "beta_sigma",
                stan::model::index_uni(
                  stan::model::rvalue(G, "G", stan::model::index_uni(i)))),
              stan::model::rvalue(beta_z, "beta_z", stan::model::index_uni(i)))),
          "assigning variable beta", stan::model::index_uni(i));
      }
      {
        current_statement__ = 30;
        lp_accum__.add(stan::math::cauchy_lpdf<false>(beta_sigma, 0, 1));
        current_statement__ = 31;
        lp_accum__.add(stan::math::exponential_lpdf<false>((2 + kappa), 0.01));
        current_statement__ = 32;
        lp_accum__.add(stan::math::normal_lpdf<false>(alpha, 0, 3));
        current_statement__ = 35;
        for (int j = 1; j <= stan::math::max(G); ++j) {
          current_statement__ = 33;
          lp_accum__.add(stan::math::normal_lpdf<false>(
                           stan::model::rvalue(beta_mu, "beta_mu",
                             stan::model::index_uni(j)), 0, 1));
        }
        current_statement__ = 39;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 36;
          lp_accum__.add(stan::math::std_normal_lpdf<false>(
                           stan::model::rvalue(beta_z, "beta_z",
                             stan::model::index_uni(i))));
          current_statement__ = 37;
          lp_accum__.add(dm_lpmf<false>(
                           stan::model::rvalue(y, "y",
                             stan::model::index_uni(i)),
                           stan::math::multiply(kappa,
                             stan::math::softmax(
                               stan::math::add(alpha,
                                 stan::model::rvalue(beta, "beta",
                                   stan::model::index_uni(i))))), pstream__));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_dmh_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double kappa = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      kappa = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,1> alpha =
        Eigen::Matrix<double,-1,1>::Constant(K,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      alpha = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(K);
      std::vector<Eigen::Matrix<double,-1,1>> beta_mu =
        std::vector<Eigen::Matrix<double,-1,1>>(beta_mu_1dim__,
          Eigen::Matrix<double,-1,1>::Constant(K,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 3;
      beta_mu = in__.template read<
                  std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>>(beta_mu_1dim__,
                  K);
      Eigen::Matrix<double,-1,1> beta_sigma =
        Eigen::Matrix<double,-1,1>::Constant(beta_sigma_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      beta_sigma = in__.template read_constrain_lb<
                     Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0,
                     lp__, beta_sigma_1dim__);
      std::vector<Eigen::Matrix<double,-1,1>> beta_z =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(K,
            std::numeric_limits<double>::quiet_NaN()));
      current_statement__ = 5;
      beta_z = in__.template read<
                 std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>>(N, K);
      std::vector<Eigen::Matrix<double,-1,1>> beta =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(K,
            std::numeric_limits<double>::quiet_NaN()));
      out__.write(kappa);
      out__.write(alpha);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= beta_mu_1dim__; ++sym2__) {
          out__.write(beta_mu[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      out__.write(beta_sigma);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          out__.write(beta_z[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 15;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 13;
        stan::model::assign(beta,
          stan::math::add(
            stan::model::rvalue(beta_mu, "beta_mu",
              stan::model::index_uni(
                stan::model::rvalue(G, "G", stan::model::index_uni(i)))),
            stan::math::multiply(
              stan::model::rvalue(beta_sigma, "beta_sigma",
                stan::model::index_uni(
                  stan::model::rvalue(G, "G", stan::model::index_uni(i)))),
              stan::model::rvalue(beta_z, "beta_z", stan::model::index_uni(i)))),
          "assigning variable beta", stan::model::index_uni(i));
      }
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            out__.write(beta[(sym2__ - 1)][(sym1__ - 1)]);
          }
        }
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<std::vector<int>> y_hat =
        std::vector<std::vector<int>>(N,
          std::vector<int>(K, std::numeric_limits<int>::min()));
      std::vector<double> log_lik =
        std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      std::vector<Eigen::Matrix<double,-1,1>> p =
        std::vector<Eigen::Matrix<double,-1,1>>(N,
          Eigen::Matrix<double,-1,1>::Constant(K,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,1>> delta =
        std::vector<Eigen::Matrix<double,-1,1>>(N_delta,
          Eigen::Matrix<double,-1,1>::Constant(K_delta,
            std::numeric_limits<double>::quiet_NaN()));
      std::vector<Eigen::Matrix<double,-1,1>> epsilon =
        std::vector<Eigen::Matrix<double,-1,1>>(N_delta,
          Eigen::Matrix<double,-1,1>::Constant(K_delta,
            std::numeric_limits<double>::quiet_NaN()));
      int k = std::numeric_limits<int>::min();
      current_statement__ = 12;
      k = 1;
      current_statement__ = 20;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 16;
        stan::model::assign(p,
          stan::math::dirichlet_rng(
            stan::math::multiply(kappa,
              stan::math::softmax(
                stan::math::add(alpha,
                  stan::model::rvalue(beta, "beta", stan::model::index_uni(i))))),
            base_rng__), "assigning variable p", stan::model::index_uni(i));
        current_statement__ = 17;
        stan::model::assign(y_hat,
          stan::math::multinomial_rng(
            stan::model::rvalue(p, "p", stan::model::index_uni(i)),
            stan::math::sum(
              stan::model::rvalue(y, "y", stan::model::index_uni(i))),
            base_rng__), "assigning variable y_hat",
          stan::model::index_uni(i));
        current_statement__ = 18;
        stan::model::assign(log_lik,
          dm_lpmf<false>(
            stan::model::rvalue(y, "y", stan::model::index_uni(i)),
            stan::math::multiply(kappa,
              stan::math::softmax(
                stan::math::add(alpha,
                  stan::model::rvalue(beta, "beta", stan::model::index_uni(i))))),
            pstream__), "assigning variable log_lik",
          stan::model::index_uni(i));
      }
      current_statement__ = 29;
      if (stan::math::logical_eq(compute_delta, 1)) {
        current_statement__ = 27;
        for (int i = 1; i <= stan::math::max(G); ++i) {
          current_statement__ = 25;
          for (int j = (i + 1); j <= stan::math::max(G); ++j) {
            current_statement__ = 21;
            stan::model::assign(delta,
              stan::math::subtract(
                stan::model::rvalue(beta_mu, "beta_mu",
                  stan::model::index_uni(i)),
                stan::model::rvalue(beta_mu, "beta_mu",
                  stan::model::index_uni(j))), "assigning variable delta",
              stan::model::index_uni(k));
            current_statement__ = 22;
            stan::model::assign(epsilon,
              stan::math::subtract(
                stan::math::softmax(
                  stan::math::add(alpha,
                    stan::model::rvalue(beta, "beta",
                      stan::model::index_uni(i)))),
                stan::math::softmax(
                  stan::math::add(alpha,
                    stan::model::rvalue(beta, "beta",
                      stan::model::index_uni(j))))),
              "assigning variable epsilon", stan::model::index_uni(k));
            current_statement__ = 23;
            k = (k + 1);
          }
        }
      }
      current_statement__ = 9;
      stan::math::check_simplex(function__, "p", p);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          out__.write(y_hat[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      out__.write(log_lik);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          out__.write(p[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      for (int sym1__ = 1; sym1__ <= K_delta; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_delta; ++sym2__) {
          out__.write(delta[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      for (int sym1__ = 1; sym1__ <= K_delta; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_delta; ++sym2__) {
          out__.write(epsilon[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      out__.write(k);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ kappa = DUMMY_VAR__;
      current_statement__ = 1;
      kappa = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, kappa);
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(alpha,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(K),
        "assigning variable alpha");
      out__.write(alpha);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> beta_mu =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(beta_mu_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__));
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= beta_mu_1dim__; ++sym2__) {
          current_statement__ = 3;
          stan::model::assign(beta_mu, in__.read<local_scalar_t__>(),
            "assigning variable beta_mu", stan::model::index_uni(sym2__),
            stan::model::index_uni(sym1__));
        }
      }
      out__.write(beta_mu);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_sigma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(beta_sigma_1dim__,
          DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(beta_sigma,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(beta_sigma_1dim__),
        "assigning variable beta_sigma");
      out__.write_free_lb(0, beta_sigma);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> beta_z =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__));
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 5;
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          current_statement__ = 5;
          stan::model::assign(beta_z, in__.read<local_scalar_t__>(),
            "assigning variable beta_z", stan::model::index_uni(sym2__),
            stan::model::index_uni(sym1__));
        }
      }
      out__.write(beta_z);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "kappa", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "alpha", "double",
        std::vector<size_t>{static_cast<size_t>(K)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "beta_mu",
        "double",
        std::vector<size_t>{static_cast<size_t>(beta_mu_1dim__),
          static_cast<size_t>(K)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "beta_sigma",
        "double",
        std::vector<size_t>{static_cast<size_t>(beta_sigma_1dim__)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "beta_z", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(K)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ kappa = DUMMY_VAR__;
      current_statement__ = 1;
      kappa = context__.vals_r("kappa")[(1 - 1)];
      out__.write_free_lb(0, kappa);
      Eigen::Matrix<local_scalar_t__,-1,1> alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 2;
        alpha_flat__ = context__.vals_r("alpha");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          stan::model::assign(alpha, alpha_flat__[(pos__ - 1)],
            "assigning variable alpha", stan::model::index_uni(sym1__));
          current_statement__ = 2;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(alpha);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> beta_mu =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(beta_mu_1dim__,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> beta_mu_flat__;
        current_statement__ = 3;
        beta_mu_flat__ = context__.vals_r("beta_mu");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= beta_mu_1dim__; ++sym2__) {
            current_statement__ = 3;
            stan::model::assign(beta_mu, beta_mu_flat__[(pos__ - 1)],
              "assigning variable beta_mu", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 3;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(beta_mu);
      Eigen::Matrix<local_scalar_t__,-1,1> beta_sigma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(beta_sigma_1dim__,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_sigma_flat__;
        current_statement__ = 4;
        beta_sigma_flat__ = context__.vals_r("beta_sigma");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= beta_sigma_1dim__; ++sym1__) {
          current_statement__ = 4;
          stan::model::assign(beta_sigma, beta_sigma_flat__[(pos__ - 1)],
            "assigning variable beta_sigma", stan::model::index_uni(sym1__));
          current_statement__ = 4;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, beta_sigma);
      std::vector<Eigen::Matrix<local_scalar_t__,-1,1>> beta_z =
        std::vector<Eigen::Matrix<local_scalar_t__,-1,1>>(N,
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant(K, DUMMY_VAR__));
      {
        std::vector<local_scalar_t__> beta_z_flat__;
        current_statement__ = 5;
        beta_z_flat__ = context__.vals_r("beta_z");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 5;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 5;
            stan::model::assign(beta_z, beta_z_flat__[(pos__ - 1)],
              "assigning variable beta_z", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 5;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(beta_z);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"kappa", "alpha", "beta_mu",
                "beta_sigma", "beta_z"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"beta"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string>
        temp{"y_hat", "log_lik", "p", "delta", "epsilon", "k"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(K)},
                std::vector<size_t>{static_cast<size_t>(beta_mu_1dim__),
                  static_cast<size_t>(K)},
                std::vector<size_t>{static_cast<size_t>(beta_sigma_1dim__)},
                std::vector<size_t>{static_cast<size_t>(N),
                  static_cast<size_t>(K)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(K)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(K)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(K)},
             std::vector<size_t>{static_cast<size_t>(N_delta),
               static_cast<size_t>(K_delta)},
             std::vector<size_t>{static_cast<size_t>(N_delta),
               static_cast<size_t>(K_delta)}, std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "kappa");
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= beta_mu_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta_mu" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= beta_sigma_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_sigma" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta_z" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "y_hat" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "p" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= K_delta; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_delta; ++sym2__) {
          param_names__.emplace_back(std::string() + "delta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= K_delta; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_delta; ++sym2__) {
          param_names__.emplace_back(std::string() + "epsilon" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      param_names__.emplace_back(std::string() + "k");
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "kappa");
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= beta_mu_1dim__; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta_mu" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= beta_sigma_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta_sigma" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta_z" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "y_hat" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= (K - 1); ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "p" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= K_delta; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_delta; ++sym2__) {
          param_names__.emplace_back(std::string() + "delta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= K_delta; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_delta; ++sym2__) {
          param_names__.emplace_back(std::string() + "epsilon" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      param_names__.emplace_back(std::string() + "k");
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"kappa\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"beta_mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(beta_mu_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"parameters\"},{\"name\":\"beta_sigma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(beta_sigma_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"beta_z\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"y_hat\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"array\",\"length\":" + std::to_string(K) + ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"p\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"generated_quantities\"},{\"name\":\"delta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_delta) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_delta) + "}},\"block\":\"generated_quantities\"},{\"name\":\"epsilon\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_delta) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_delta) + "}},\"block\":\"generated_quantities\"},{\"name\":\"k\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"kappa\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "},\"block\":\"parameters\"},{\"name\":\"beta_mu\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(beta_mu_1dim__) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"parameters\"},{\"name\":\"beta_sigma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(beta_sigma_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"beta_z\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K) + "}},\"block\":\"transformed_parameters\"},{\"name\":\"y_hat\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"array\",\"length\":" + std::to_string(K) + ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"p\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string((K -1)) + "}},\"block\":\"generated_quantities\"},{\"name\":\"delta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_delta) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_delta) + "}},\"block\":\"generated_quantities\"},{\"name\":\"epsilon\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_delta) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(K_delta) + "}},\"block\":\"generated_quantities\"},{\"name\":\"k\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((1 + K) + (beta_mu_1dim__ * K)) +
      beta_sigma_1dim__) + (N * K));
    const size_t num_transformed = emit_transformed_parameters * ((N * K));
    const size_t num_gen_quantities = emit_generated_quantities * (((((((N *
      K) + N) + (N * K)) + (N_delta * K_delta)) + (N_delta * K_delta)) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((1 + K) + (beta_mu_1dim__ * K)) +
      beta_sigma_1dim__) + (N * K));
    const size_t num_transformed = emit_transformed_parameters * ((N * K));
    const size_t num_gen_quantities = emit_generated_quantities * (((((((N *
      K) + N) + (N * K)) + (N_delta * K_delta)) + (N_delta * K_delta)) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_dmh_namespace::model_dmh;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_dmh_namespace::profiles__;
}
#endif
#endif
