% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClustAll_ClustAllObject_Class.R
\docType{class}
\name{numericOrNA-class}
\alias{numericOrNA-class}
\title{Class Union: numericOrNA}
\description{
This class union allows for flexibility in method signatures and slot
definitions by accepting either a numeric value, NULL, or a missing value.
It is particularly useful when a slot or function parameter might contain
a numeric value but could also be empty, unspecified, or explicitly set to NULL.
}
\details{
The numericOrNA class union includes:
\itemize{
  \item numeric: A standard R numeric value or vector
  \item NULL: Representing an empty or unset value
  \item missing: Allowing for unspecified parameters in function calls
}

This union is useful in scenarios where:
\itemize{
  \item A function might return a numeric result or NULL if no result is available
  \item A slot in an S4 object could contain a numeric value or be empty
  \item A function parameter could accept a numeric input, but also work with default settings if nothing is provided
}
}
\seealso{
\code{\link{setClassUnion}}, \code{\link{ClustAllObject-class}}
}
