% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankingCoxPH.R
\name{colCoxTests}
\alias{colCoxTests}
\title{A function to perform fast or standard Cox proportional hazard model tests.}
\usage{
colCoxTests(measurements, outcome, option = c("fast", "slow"), ...)
}
\arguments{
\item{measurements}{matrix with variables as columns.}

\item{outcome}{matrix with first column as time and second column as event.}

\item{option}{Default: \code{"fast"}. Whether to use the fast or slow method.}

\item{...}{Not currently used.}
}
\value{
CrossValParams object
}
\description{
A function to perform fast or standard Cox proportional hazard model tests.
}
\examples{
data(asthma)
time <- rpois(nrow(measurements), 100)
status <- sample(c(0,1), nrow(measurements), replace = TRUE)
outcome <- cbind(time, status)
output <- colCoxTests(measurements, outcome, "fast")
}
