% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importanceADT.R
\name{visImportance}
\alias{visImportance}
\title{visImportance}
\usage{
visImportance(
  sce,
  plot = c("boxplot", "heatmap"),
  altExp_name = "ADT",
  exprs_value = "logcounts"
)
}
\arguments{
\item{sce}{A singlecellexperiment object}

\item{plot}{A string indicates the type of the plot
(either boxplot or heatmap)}

\item{altExp_name}{A character indicates which expression matrix
is used. by default is none (i.e. RNA).}

\item{exprs_value}{A character indicates which expression value
in assayNames is used.}
}
\value{
A plot (either ggplot or pheatmap) to visualise
the ADT importance results
}
\description{
A function to visualise the features distribtuion
}
\examples{
data("sce_control_subset", package = "CiteFuse")
sce_control_subset <- importanceADT(sce_control_subset,
group = sce_control_subset$SNF_W_louvain,
subsample = TRUE)
visImportance(sce_control_subset, plot = "boxplot")

}
