% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{normalize_scExp}
\alias{normalize_scExp}
\title{Normalize counts}
\usage{
normalize_scExp(
  scExp,
  type = c("CPM", "TFIDF", "RPKM", "TPM", "feature_size_only")
)
}
\arguments{
\item{scExp}{A SingleCellExperiment object.}

\item{type}{Which normalization to apply. Either 'CPM', 'TFIDF','RPKM', 'TPM' or
'feature_size_only'. Note that for all normalization by size
(RPKM, TPM, feature_size_only), the features must have defined
genomic coordinates.}
}
\value{
A SingleCellExperiment object containing normalized counts.
(See ?normcounts())
}
\description{
Normalize counts
}
\examples{
raw <- create_scDataset_raw()
scExp = create_scExp(raw$mat, raw$annot)
scExp = normalize_scExp(scExp)
head(SingleCellExperiment::normcounts(scExp))

}
