% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_filtering_clustering.R
\name{intra_correlation_scExp}
\alias{intra_correlation_scExp}
\title{Calculate intra correlation between cluster or samples}
\usage{
intra_correlation_scExp(
  scExp_cf,
  by = c("sample_id", "cell_cluster")[1],
  fullCor = TRUE
)
}
\arguments{
\item{scExp_cf}{A SingleCellExperiment}

\item{by}{On which feature to calculate correlation ("sample_id" or
"cell_cluster")}

\item{fullCor}{Logical specifying if the correlation matrix was run on the
entire number of cells or on a subset.}
}
\value{
A data.frame of cell average intra-correlation
}
\description{
Calculate intra correlation between cluster or samples
}
\examples{
data(scExp)
intra_correlation_scExp(scExp, by = "sample_id")
intra_correlation_scExp(scExp, by = "cell_cluster")
}
