% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{import_scExp}
\alias{import_scExp}
\title{Read single-cell matrix(ces) into scExp}
\usage{
import_scExp(file_paths, remove_pattern = "", temp_path = NULL)
}
\arguments{
\item{file_paths}{A character vector of file names towards single cell
epigenomic matrices (features x cells) (must be .txt / .tsv)}

\item{remove_pattern}{A string pattern to remove from the sample names. Can
be a regexp.}

\item{temp_path}{In case matrices are stored in temporary folder,
a character vector of path towards temporary files. (NULL)}
}
\value{
A list containing:
\itemize{
\item datamatrix: a sparseMatrix of features x cells
\item annot_raw: an annotation of cells as data.frame
}
}
\description{
Combine one or multiple matrices together to create a sparse matrix and cell
annotation data.frame.
}
\examples{
mat1 = mat2 = create_scDataset_raw()$mat
tmp1 = tempfile(fileext = ".tsv")
tmp2 = tempfile(fileext = ".tsv")
write.table(as.matrix(mat1),file=tmp1,sep = "\t",
row.names = TRUE,col.names = TRUE,quote = FALSE)
write.table(as.matrix(mat2),file=tmp2, sep = "\t",
row.names = TRUE,col.names = TRUE,quote = FALSE)
file_paths = c(tmp1,tmp2)
out = import_scExp(file_paths)

}
