% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_filtering_clustering.R
\name{correlation_and_hierarchical_clust_scExp}
\alias{correlation_and_hierarchical_clust_scExp}
\title{Correlation and hierarchical clustering}
\usage{
correlation_and_hierarchical_clust_scExp(scExp, hc_linkage = "ward.D")
}
\arguments{
\item{scExp}{A SingleCellExperiment object, containing 'PCA' in reducedDims.}

\item{hc_linkage}{A linkage method for hierarchical clustering. See
\link[stats]{cor}. ('ward.D')}
}
\value{
Return a SingleCellExperiment object with correlation matrix &
hiearchical clustering.
}
\description{
Calculates cell to cell correlation matrix based on the PCA feature space and
runs hierarchical clustering taking 1 - correlation scores as distance.
}
\details{
This functions takes as input a SingleCellExperiment object that must have
PCA calculated and outputs a SingleCellExperiment object with correlation
matrix and hierarchical clustering.
}
\examples{
data("scExp")
scExp_cf = correlation_and_hierarchical_clust_scExp(scExp)

}
