% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{GetGroupGeneSet}
\alias{GetGroupGeneSet}
\alias{GetGroupGeneSet.Seurat}
\alias{GetGroupGeneSet.SingleCellExperiment}
\title{Extract cluster/group gene sets from MCA}
\usage{
GetGroupGeneSet(X, group.by, reduction, dims, features, n.features)

\method{GetGroupGeneSet}{Seurat}(
  X,
  group.by = NULL,
  reduction = "mca",
  dims = seq(50),
  features = NULL,
  n.features = 200
)

\method{GetGroupGeneSet}{SingleCellExperiment}(
  X,
  group.by = NULL,
  reduction = "MCA",
  dims = seq(50),
  features = NULL,
  n.features = 200
)
}
\arguments{
\item{X}{Seurat or SingleCellExperiment object, alternatively a matrix.}

\item{group.by}{column name of meta.data (Seurat) or ColData (SingleCellExperiment).}

\item{reduction}{Which dimensionality reduction to use, must be based on MCA.}

\item{dims}{A vector of integers indicating which dimensions to use with reduction for distance calculation.}

\item{features}{A character vector of features name to subset feature coordinates for distance calculation.}

\item{n.features}{A single integer specifying how many top features will be extracted from ranking.}
}
\value{
Distance Matrix between groups (column) and genes (row)
}
\description{
Extract cluster/group gene sets from MCA
}
\examples{
seuratPbmc <- RunMCA(seuratPbmc, nmcs = 5)
GroupGeneSet <- GetGroupGeneSet(seuratPbmc, dims = 1:5, group.by = "seurat_clusters")
}
