% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-methods.R
\docType{methods}
\name{latentSpace}
\alias{latentSpace}
\alias{latentSpace,SingleCellExperiment-method}
\title{GET CellTrails' latent space}
\usage{
latentSpace(object)
}
\arguments{
\item{object}{A \code{SingleCellExperiment} object}
}
\value{
An object of class \code{matrix}
}
\description{
Retrieve computed latent space from a \code{SingleCellExperiment} object.
}
\details{
Returns the latent space set for a CellTrails analysis. The
resulting matrix is numeric. Rows are samples and columns are \emph{d}
components. It is a wrapper for \code{reducedDim} to ensure
that the proper matrix is received from a \code{SingleCellExperiment}
object.
}
\examples{
# Example data
data(exSCE)

# Get latent space
latentSpace(exSCE)[seq_len(5), ]
}
\seealso{
\code{SingleCellExperiment} \code{reducedDim}
}
\author{
Daniel C. Ellwanger
}
