% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-methods.R
\docType{methods}
\name{latentSpace<-}
\alias{latentSpace<-}
\alias{latentSpace<-,SingleCellExperiment-method}
\title{SET latent space}
\usage{
latentSpace(object) <- value
}
\arguments{
\item{object}{A \code{SingleCellExperiment} object}

\item{value}{A numeric matrix with rows are samples and columns are
components}
}
\value{
An updated object of class \code{SingleCellExperiment}
}
\description{
Set CellTrails' latent space to a \code{SingleCellExperiment} object.
}
\details{
Rows need to be samples and columns to be \emph{d} components
(spanning the lower-dimensional latent space).
}
\examples{
# Example data
data(exSCE)

# Set latent space
latentSpace(exSCE) <- pca(exSCE)$components[, seq_len(10)]
}
\seealso{
\code{SingleCellExperiment} \code{reducedDim}
}
\author{
Daniel C. Ellwanger
}
