% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{filterTrajFeaturesByCOV}
\alias{filterTrajFeaturesByCOV}
\alias{filterTrajFeaturesByCOV,SingleCellExperiment-method}
\title{Filter features by Coefficient of Variation (COV)}
\usage{
filterTrajFeaturesByCOV(sce, threshold, design = NULL, show_plot = TRUE)
}
\arguments{
\item{sce}{An \code{SingleCellExperiment} object}

\item{threshold}{Minimum coefficient of variation;
numeric value between 0 and 1}

\item{design}{A numeric matrix describing the factors that should be blocked}

\item{show_plot}{Indicates if plot should be shown (default: TRUE)}
}
\value{
A \code{character} vector
}
\description{
Filters trajectory features by their coefficient of variation.
}
\details{
For each trajectory feature \emph{x} listed in the
\code{SingleCellExperiment} object the coefficient of variation is
computed by \eqn{CoV(x) = sd(x) / mean(x)}. Features with a CoV(x) greater
than \code{threshold} remain labeled as trajectory feature in the
\code{SingleCellExperiment} object, otherwise they are not considered
for dimensionality reduction, clustering and trajectory reconstruction.
Please note that spike-in controls are ignored
and are not listed as trajectory features.
\cr \cr
To account for systematic bias in the expression data
(e.g., cell cycle effects), a design matrix can be provided for the
learning process. It should list the factors that should be blocked and
their values per sample. It is suggested to construct a design
matrix with \code{model.matrix}.
}
\examples{
# Simulate example data
set.seed(1101)
dat <- simulate_exprs(n_features=15000, n_samples=100)

# Create container
alist <- list(logcounts=dat)
sce <- SingleCellExperiment(assays=alist)

# Filter incrementally
trajFeatureNames(sce) <- filterTrajFeaturesByDL(sce, threshold=2)
trajFeatureNames(sce) <- filterTrajFeaturesByCOV(sce, threshold=0.5)

# Number of features
length(trajFeatureNames(sce)) #filtered
nrow(sce) #total
}
\seealso{
\code{trajFeatureNames} \code{model.matrix}
}
\author{
Daniel C. Ellwanger
}
