% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimred-methods.R
\name{.bhtsne}
\alias{.bhtsne}
\title{#' DEF: Truncate eigenbasis
#'
#' For details see \code{reduceDimensions}
#' @keywords internal
#' @author Daniel C. Ellwanger
.reduceDimensions_def <- function(x, s) {
  CellTrails::latentSpace(x) <- CellTrails::latentSpace(x)[, seq_len(s@n)]
  CellTrails::eigenvalues(x) <- CellTrails::eigenvalues(x)[seq_len(s@n)]
  x
}
t-Distributed Stochastic Neighbor Embedding}
\usage{
.bhtsne(x, dims = 2, perplexity = 30, theta = 0.5, max_iter = 1000)
}
\arguments{
\item{x}{A numerical matrix}

\item{dims}{Output dimensionality}

\item{perplexity}{Perplexity parameter (default: 30)}

\item{theta}{Speed/accuracy trade-off (increase for less accuracy),
set to 0.0 for exact tSNE (default: .5)}

\item{max_iter}{Number of iterations (default: 1000)}
}
\value{
A list with the following components:
\describe{
  \item{\code{Y}}{Matrix containing the new representations for the objects}
  \item{\code{perplexity}}{See above}
}
}
\description{
Barnes-Hut implementation of t-Distributed Stochastic Neighbor Embedding
}
\author{
Daniel C. Ellwanger
}
\keyword{internal}
