% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{contrastTrailExpr}
\alias{contrastTrailExpr}
\alias{contrastTrailExpr,SingleCellExperiment-method}
\title{Differential trail expression analysis}
\usage{
contrastTrailExpr(
  sce,
  feature_names = featureNames(sce),
  trail_names,
  score = "rmsd"
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{feature_names}{Name of feature; can be multiple names}

\item{trail_names}{Name of trails}

\item{score}{Score type; one of \{"rmsd", "tad", "abc", "cor"\}}
}
\value{
Numeric value
}
\description{
Comparison of feature expression dynamic between two trails.
}
\details{
Genes have non-uniform expression rates and each trail
has a distinct set of upregulated genes, but also contains unequal
numbers of cells. Because pseudotime is based on transcriptional change,
its axis may be distorted, leading to stretched or compressed sections of
longitudinal expression data that make comparison of trails challenging.
To align different trails, despite these differences, CellTrails employs a
dynamic programming based algorithm that has long been known in speech
recognition, called dynamic time warping (Sakoe and Chiba, 1978). RNA
expression rates are modeled analogous to speaking rates
(Aach and Church, 2001);  the latter accounts for innate non-linear
variation in the length of individual phonemes (i.e., states) resulting in
stretching and shrinking of word (i.e., trail) segments. This allows the
computation of inter-trail alignment warps of individual expression time
series that are similar but locally out of phase.
\cr \cr
Univariate pairwise alignments are
computed resulting in one warp per feature and per trail set. Similar to a
(global) pairwise protein sequence alignment, monotonicity
(i.e., no time loops) and continuity (i.e., no time leaps) constraints have
to be imposed on the warping function to preserve temporal sequence ordering.
To find the optimal warp, a recursion rule is applied which selects the
local minimum of three moves through a dynamic programming matrix:
suppose that query snapshot \emph{g} and reference snapshot \emph{h}
have already been aligned, then the alignment of \emph{h}+1 with
\emph{g}+1 is a (unit slope) diagonal move, \emph{h} with
\emph{g}+1 denotes an expansion by repetition of \emph{h},
and \emph{h}+2 with \emph{g}+1 contracts the query by dropping \emph{h}+1.
\cr \cr
The overall dissimilarity between two aligned expression time series
\emph{x} and \emph{y}
of length \emph{n} is estimated by either the root-mean-square deviation
\eqn{RMSD(x, y) = \sqrt(\sum(x - y)^2/n)}, the total aboslute deviation
\eqn{TAD(x, y) = \sum(|x-y|)},
the area between the aligned dynamic curves (\code{ABC}), or Pearson's
correlation coefficient (\code{cor}) over all aligned elements.
}
\examples{
# Example data
data(exSCE)

# Differential expression between trails
contrastTrailExpr(exSCE, feature_name=c("feature_1", "feature_10"),
                 trail_names=c("Tr1", "Tr2"), score="rmsd")
}
\references{
Sakoe, H., and Chiba, S. (1978). Dynamic programming algorithm
optimization for spoken word recognition. IEEE Transactions on Acoustics,
Speech, and Signaling Processing 26, 43-49.

Aach, J., and Church, G.M. (2001). Aligning gene expression
time series with time warping algorithms. Bioinformatics 17, 495-508.
}
\seealso{
\code{dtw}
}
\author{
Daniel C. Ellwanger
}
