% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-seqQc.R
\name{bc_summary_seqQc}
\alias{bc_summary_seqQc}
\alias{bc_summary_seqQc,BarcodeQcSet-method}
\title{Summary barcodeQcSet}
\usage{
bc_summary_seqQc(x)

\S4method{bc_summary_seqQc}{BarcodeQcSet}(x)
}
\arguments{
\item{x}{a barcodeQcSet object.}
}
\value{
A \code{data.frame} with 5 columns: \code{sample_name},
\code{total_read}, \code{median_read_length}, \code{p5_read_length} and
\code{p95_read_length.}
}
\description{
Summary the "total read count" and "read length" of each samples within
a \code{BarcodeQcSet} object, and output a \code{data.frame} with sample by
row and different metrics by column.
}
\examples{

fq_file <- dir(
    system.file("extdata", "mef_test_data", package = "CellBarcode"),
    full=TRUE)

bc_summary_seqQc(bc_seq_qc(fq_file))
###
}
