% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-BarcodeObj.R
\name{bc_meta}
\alias{bc_meta}
\alias{bc_meta<-}
\alias{bc_meta,BarcodeObj-method}
\alias{bc_meta<-,BarcodeObj-method}
\title{Accesses and sets metadata in BarcodeObj object}
\usage{
bc_meta(barcodeObj)

bc_meta(barcodeObj, key = NULL) <- value

\S4method{bc_meta}{BarcodeObj}(barcodeObj)

\S4method{bc_meta}{BarcodeObj}(barcodeObj, key = NULL) <- value
}
\arguments{
\item{barcodeObj}{A \code{BarcodeObj} object.}

\item{key}{A string, identifying the metadata record name to be modified.}

\item{value}{A string vector or a data.frame. If the \code{value} is a
vector, it should have the same length of sample number in the BarcodeObj
object.  Otherwise, if the \code{value} is \code{data.frame}, the row name of
the \code{data.frame} should be the sample name, and each column as a
metadata variable.}
}
\value{
A data.frame
}
\description{
Sample information is kept in metadata. \code{bc_meta} is for accessing and
updating metadata in \code{BarcodeObj} object
}
\examples{
data(bc_obj)

# get the metadata data.frame
bc_meta(bc_obj)

# assign value to metadata by $ operation
bc_meta(bc_obj)$phenotype <- c("l", "b")

# assign value to metadata by "key" argument
bc_meta(bc_obj, key = "sample_type") <- c("l", "b")

# show the updated metadata
bc_meta(bc_obj)

# assign new data.frame to metadata
metadata <- data.frame(
    sample_name <- c("test1", "test2"),
    phenotype <- c("l", "b")
    )
rownames(metadata) = bc_names(bc_obj)
bc_meta(bc_obj) <- metadata
###
}
