% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSCANR.r
\name{runSCANR}
\alias{runSCANR}
\title{run ScanR}
\usage{
runSCANR(network, experimentalData, numberOfDeltaToScan = 5,
  topNumGenes = 150, correctPredictionsThreshold = Inf,
  writeResultFiles = TRUE, writeNetworkFiles = "all", doParallel = FALSE,
  numCores = NULL, quiet = FALSE, outputDir = getwd())
}
\arguments{
\item{network}{Computational Causal Graph, as an igraph.}

\item{experimentalData}{The experimental data read in using \link{ReadExperimentalData}. The results is an n x 2 matrix; where the first column contains the node ids of the nodes in the network that the results refer to. The second column contains values indicating the direction of regulation in the results - (+)1 for up, -1 for down and 0 for insignificant amounts of regulation.}

\item{numberOfDeltaToScan}{Iteratively scan for 1 to numberOfDeltaToScan delta values}

\item{topNumGenes}{A value to select top genes to report (typically top 100 genes)}

\item{correctPredictionsThreshold}{Minimal score for p-values calculation. Value is passed to RankTheHypothesis - scores below this value will get NAs for p-value and enrichment p-value. The default is Inf, so that no p-values are calculated.}

\item{writeResultFiles}{If set to TRUE the results of the scan will be written to two text files in the working directory. Default is TRUE.}

\item{writeNetworkFiles}{If set to "all" .sif files and corresponding _anno.txt files will be generated for the top correctly explained, incorrectly explained and ambiguously explained nodes. If set to "correct" they will only be calculated for correctly explained nodes. If set to "none", no networks will be generated. Default is "all".}

\item{doParallel}{A flag for running RankTheHypothesis in parallel mode. Default is FALSE.}

\item{numCores}{Number of cores to use if using parallel mode. If the default value of NULL is used, it will attempt to detect the number of cores available and use all of them bar one.}

\item{quiet}{a flag to suppress output to console. FALSE by default.}

\item{outputDir}{the directory to output the files to. Default is the working directory}
}
\value{
returns list of genes from each delta scan run
}
\description{
This function will return nodes regulated by the given hypothesisGene
}
\examples{
numberOfDeltaToScan <- 2
topNumGenes <- 4
#get path to example network file
networkFile <- system.file(package = 'CausalR', 'extdata', 'testNetwork.sif')
#create ccg
network <-  CreateCCG(networkFile)
#get path to example experimental data
experimentalDataFile <- system.file(package = 'CausalR', 'extdata', 'testData.txt')
#read in experimetal data
experimentalData <-  ReadExperimentalData(experimentalDataFile, network)
#run in single threaded mode
runSCANR(network, experimentalData, numberOfDeltaToScan, topNumGenes)
#run in parallel mode
runSCANR(network, experimentalData, numberOfDeltaToScan, topNumGenes,
         doParallel = TRUE, numCores = 2)
}
\concept{
CausalR
}

