% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetExplainedNodesOfCCG.r
\name{GetExplainedNodesOfCCG}
\alias{GetExplainedNodesOfCCG}
\title{Get explained nodes of CCG}
\usage{
GetExplainedNodesOfCCG(hypothesisnode, signOfHypothesis, network,
  experimentalData, delta)
}
\arguments{
\item{hypothesisnode}{a hypothesis node}

\item{signOfHypothesis}{the direction of change of hypothesis node}

\item{network}{a computational causal graph}

\item{experimentalData}{The experimental data read in using \link{ReadExperimentalData}. The results is an n x 2 matrix; where the first column contains the node ids of the nodes in the network that the results refer to. The second column contains values indicating the direction of regulation in the results - (+)1 for up, -1 for down and 0 for insignificant amounts of regulation. The name of the first column is the filename the data was read from.}

\item{delta}{the number of edges across which the hypothesis should be followed}
}
\value{
vector of explained nodes
}
\description{
Returns a table of node names and values for explained nodes, I.e. nodes that appear in both network and data with the same sign.
The table contain the name in column 1 and the value (1 or -1) in column 2
}

