% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetApproximateMaximumDValueFromTwoByTwoContingencyTable.r
\name{GetApproximateMaximumDValueFromTwoByTwoContingencyTable}
\alias{GetApproximateMaximumDValueFromTwoByTwoContingencyTable}
\title{computes an approximate maximum D value or weight}
\usage{
GetApproximateMaximumDValueFromTwoByTwoContingencyTable(n_pp, n_pm, n_mp, n_mm,
  predictionListStats, experimentalDataStats,
  logOfFactorialOfPredictionListStats, returnlog = FALSE)
}
\arguments{
\item{n_pp}{the count n++ from the prediction-observation contingency matrix}

\item{n_pm}{the count n+- from the prediction-observation contingency matrix}

\item{n_mp}{the count n-+ from the prediction-observation contingency matrix}

\item{n_mm}{the count n-- from the prediction-observation contingency matrix}

\item{predictionListStats}{a vector containing the values q+, q- and q0: the number of positive, negative, non-significant/contradictory predictions}

\item{experimentalDataStats}{a vector containing the values n+, n- and n0: the number of positive, negative, non-significant/contradictory observations}

\item{logOfFactorialOfPredictionListStats}{a vector containing the log of the factorial value for each entry in predictionListStats}

\item{returnlog}{return the result as a log, default is FALSE}
}
\value{
the maximum D value or weight
}
\description{
Computes an approximate maximum D value (or weight).
The calculation is  approximate since only the first valid D value that is round. This has been
done to speed up the overall algorithm - to get the exact answer use GetMaximumDValueFromTwoByTwoContingencyTable.
}

