% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateSignificanceUsingQuarticAlgorithm.r
\name{CalculateSignificanceUsingQuarticAlgorithm}
\alias{CalculateSignificanceUsingQuarticAlgorithm}
\title{calculate significance using the quartic algorithm}
\usage{
CalculateSignificanceUsingQuarticAlgorithm(hypothesisScore, predictionListStats,
  experimentalDataStats)
}
\arguments{
\item{hypothesisScore}{the score for which a  p-value is required}

\item{predictionListStats}{a vector containing the values q+, q- and q0 (the number of positive/negative/non-significant  or contradictory) predictions)}

\item{experimentalDataStats}{a vector containing the values n+, n- and n0 (the number of positive/negative/non-significant (or contradictory) transcripts in the results) (or contradictory) transcripts in the results)}
}
\value{
the corresponding p-value
}
\description{
Computes the significance of a given hypothesis. For a detailed description of the algorithm
see Causal reasoning on biological networks: interpreting transcriptional changes - Chindelevitch et al., section 2.
from which the methods and notation is taken.
}
\examples{
CalculateSignificance(5, c(7,4,19), c(6,6,18))
CalculateSignificance(5, c(7,4,19), c(6,6,18), useCubicAlgorithm=TRUE)
CalculateSignificanceUsingQuarticAlgorithm(5, c(7,4,19), c(6,6,18))
CalculateSignificance(5, c(7,4,19), c(6,6,18), useCubicAlgorithm=FALSE)
CalculateSignificance(5, c(7,4,19), c(6,6,18), 1e-5)
CalculateSignificance(5, c(7,4,19), c(6,6,18), epsilon=1e-5, useCubicAlgorithm=TRUE)
CalculateSignificanceUsingCubicAlgorithm(5, c(7,4,19), c(6,6,18), 1e-5)
}
\references{
L Chindelevitch et al.
Causal reasoning on biological networks: Interpreting transcriptional changes.
Bioinformatics, 28(8):1114-21, 2012.
}
\concept{
CausalR
}

