% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeometricClustering.R
\name{runGeometricClusteringTrials}
\alias{runGeometricClusteringTrials}
\title{This runs random trials to determine the statistical
significance of the clustering of a set of points
within a larger set.}
\usage{
runGeometricClusteringTrials(S, geneSubset, numTrials)
}
\arguments{
\item{S}{\itemize{
\item a set of points given as a matrix. The rows
are the coordinates of these points
}}

\item{geneSubset}{\itemize{
\item this is either a subset of the rownames of
S or a logical whose length is nrow(S)
}}

\item{numTrials}{\itemize{
\item the number or random trials to perform
}}
}
\value{
This returns a list. subsetDistance gives the
median complement distance for the actual set,
randomSubsetDistance gives the complement distances for
the numTrials random sets, pValue gives a p-value based
on the rank of the actual distance among the random
distances and zScore gives its z-score.
}
\description{
This function takes a matrix whose rows are geometric
coordinates and a subset of these points either given
as a character vector which is a subset of the rownames
or as a logical vector.  It returns statistics on the
mean distance of the complement to the subset.
}
\examples{
library(Seurat)
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
hallmark = getExample('hallmark')
S = data.matrix(FetchData(STranspose,c('umap_1','umap_2')))
geneSubset = rownames(S) \%in\% hallmark[["HALLMARK_TNFA_SIGNALING_VIA_NFKB"]]
geneClustering = runGeometricClusteringTrials(S,geneSubset,100)
}
