% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGenesVsCells.R
\name{getAverageExpressionMatrix}
\alias{getAverageExpressionMatrix}
\title{This computes average expression of each gene cluster in
each cell cluster and returns the result as a matrix}
\usage{
getAverageExpressionMatrix(
  f,
  fPrime,
  clusteringName = "seurat_clusters",
  layer = "scale.data"
)
}
\arguments{
\item{f}{\itemize{
\item The Seurat object of cells, or SingleCellExperiment
to be turned into a Seurat object
}}

\item{fPrime}{\itemize{
\item The Seurat object of genes,  or SingleCellExperiment
to be turned into a Seurat object
}}

\item{clusteringName}{In many cases, this will be the cell
clustering, i.e., seurat_clusters, which is the default, but
for neighbourhood Seurat objects, this can be
neighbourhood_clusters.}

\item{layer}{\itemize{
\item layer to use for expression values
}}
}
\value{
A matrix of the average expression where the rows
correspond to cell clusters and the columns correspond to
gene clusters.
}
\description{
This computes average expression of each gene cluster in
each cell cluster and returns the result as a matrix
}
\examples{
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
exSeuratObj = getExample('exSeuratObj',toy=TRUE)
M = getAverageExpressionMatrix(exSeuratObj,STranspose,layer='data')
}
