% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleLigandReceptorAnalysis.R
\name{computeEdgeGraph}
\alias{computeEdgeGraph}
\title{This function takes a spatial graph and computes a new spatial graph where
edges become nodes and A-B edges (in the original graph) become connected to
all A- edges and all B- edges.}
\usage{
computeEdgeGraph(spatialGraph, selfEdges = FALSE)
}
\arguments{
\item{spatialGraph}{\itemize{
\item a data frame of neighbouring edge pairs.
}}

\item{selfEdges}{\itemize{
\item a logical determining whether to include self edges.
Defaults to False.
}}
}
\value{
a graph in neighbour format  where edges in the original graph
become nodes and A-B edges (in the original graph) become connected to
all A- edges and all B- edges.
}
\description{
This function takes a spatial graph and computes a new spatial graph where
edges become nodes and A-B edges (in the original graph) become connected to
all A- edges and all B- edges.
}
\examples{
delaunayNeighbours = make.getExample()('delaunayNeighbours')
edgeNeighbours = computeEdgeGraph(delaunayNeighbours)
}
