% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embryos_mean_methylation.R
\name{embryos_mean_methylation}
\alias{embryos_mean_methylation}
\title{Promoter methylation of any gene in early embryos}
\usage{
embryos_mean_methylation(
  genes = NULL,
  stage = c("GV Oocyte", "MII Oocyte", "Sperm", "Zygote", "2-cell", "4-cell", "8-cell",
    "Morula", "Blastocyst", "Post-implantation"),
  include_CTP = FALSE,
  values_only = FALSE
)
}
\arguments{
\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{stage}{\code{character} defining the cell types to be plotted.
Can be "GV Oocyte", "MII Oocyte", "Sperm", "Zygote", "2-cell",
"4-cell", "8-cell", "Morula", "Blastocyst", "Post-implantation".}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{values_only}{\code{logical(1)}, \code{FALSE} by default. If \code{TRUE}, the
function will return the methylation values in all samples
instead of the heatmap.}
}
\value{
Heatmap of mean promoter methylation of any gene in embryos.
If \code{values_only = TRUE}, a RangedSummarizedExperiment with methylation values
is returned instead.
}
\description{
Plots a heatmap of mean promoter methylation levels of
any genes in early embryos, using WGSB data from ("Single-cell
DNA methylome sequencing of human preimplantation embryos". Zhu et al.
Nat genetics 2018). Methylation levels in tissues correspond
to the mean methylation of CpGs located in range of 1000 pb upstream and
500 pb downstream from gene TSS.
}
\examples{
embryos_mean_methylation()
embryos_mean_methylation(c("MAGEA1", "MAGEA3", "MAGEA4", "MAGEC2", "MAGEB16"),
stage = c( "MII Oocyte", "Sperm", "Zygote", "2-cell", "4-cell", "8-cell", 
"Morula"))
}
