% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oocytes_expression.R
\name{oocytes_expression}
\alias{oocytes_expression}
\title{Gene expression in oocytes}
\usage{
oocytes_expression(
  genes = NULL,
  include_CTP = FALSE,
  ncells_max = 200,
  scale_lims = NULL,
  values_only = FALSE
)
}
\arguments{
\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{ncells_max}{\code{integer(1)} Sets the number of each cell type to
represent on the heatmap (these cells will be randomly selected among each
cell type) (set to 200 by default). If \code{NULL}, all cells are displayed.}

\item{scale_lims}{\verb{vector of length 2} setting the lower and upper limits
of the heatmap colorbar. By default, the lower limit is 0, and the upper
limit corresponds to the third quartile of the logcounts values.}

\item{values_only}{\code{logical(1)}. If \code{TRUE}, the function will return the
SingleCellExperiment instead of the heatmap. Default is \code{FALSE}.}
}
\value{
A heatmap of selected CT genes expression in single cells from human
oocytes. If \code{values_only = TRUE}, a SingleCellExperiment is returned instead.
}
\description{
Plots a heatmap of genes expression in oocytes,
using scRNAseq data from "Decoding dynamic epigenetic landscapes in human
oocytes using single-cell multi-omics sequencing"
(Yan et al. Cell Stem Cell 2021)
}
\examples{
\dontrun{
oocytes_expression(include_CTP = FALSE, ncells_max = 100,
                  values_only = FALSE)
}
}
