% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_ctd_chem.R
\name{query_ctd_chem}
\alias{query_ctd_chem}
\title{Function to query CTDbase using chemical terminology ( Chemical Name )}
\usage{
query_ctd_chem(terms, max.distance = 10, ask = FALSE, verbose = FALSE)
}
\arguments{
\item{terms}{Character vector with the chemicals used in the query.}

\item{max.distance}{(default \code{10}) Maximum distance allowed between a given element
in \code{terms} argument and a possible match in CTDbase.}

\item{ask}{(default \code{TRUE}) If \code{TRUE} it asks the the persistent
location must be used to save the vocabulary if it was not downloaded
previously.}

\item{verbose}{(default \code{FALSE}) If set to \code{TRUE} is shows relevant
information of each step.}
}
\value{
An object of class \code{\link{CTDdata}}.
}
\description{
This function checks for CTDbase gene vocabulary and query CTDbase
for each one, downloading chemical-genes interactions, associated
diseases, associated KEGG pathways and associated GO terms.
}
\examples{
# Example in a tryCatch, since we are performing a connection to a server we might
# get a refused connection due to a server rejection. Evaluate the recieved HTTP 
# message to understand if the server is not available or if your IP adress is temporarly restricted
rst <- tryCatch({query_ctd_chem( terms = c( "Iron", "Air Pollutants" ), verbose = TRUE )}, error = function(w){NULL})
}
