% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_ctd.R
\name{load_ctd_dise}
\alias{load_ctd_dise}
\title{Function to load the \code{.tsv.gz} file for disease}
\usage{
load_ctd_dise(verbose = FALSE)
}
\arguments{
\item{verbose}{(default \code{FALSE}) If set to \code{TRUE} messages and
warnings are raised.}
}
\value{
A \code{data.frame} with the content of the file "CTD_genes.tsv.gz"
}
\description{
Function to load the \code{.tsv.gz} file for disease
}
\details{
The field included in the file (\code{CTD_diseases.tsv.gz}) are:
\enumerate{
 \item DiseaseName
 \item DiseaseID (MeSH or OMIM identifier)
 \item Definition
 \item AltDiseaseIDs (alternative identifiers; '|'-delimited list)
 \item ParentIDs (identifiers of the parent terms; '|'-delimited list)
 \item TreeNumbers (identifiers of the disease's nodes; '|'-delimited list)
 \item ParentTreeNumbers (identifiers of the parent nodes; '|'-delimited list)
 \item Synonyms ('|'-delimited list)
 \item SlimMappings (MEDIC-Slim mappings; '|'-delimited list)
 }
}
\examples{
if(download_ctd_dise()){
fdl <- load_ctd_dise()
dim( fdl )
}
}
