% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllGenerics.R
\name{get_table}
\alias{get_table}
\title{Method to obtain a specific inner table from a \code{CTDdata} object.}
\usage{
get_table(object, index_name, ...)
}
\arguments{
\item{object}{Object of class \code{CTDdata}.}

\item{index_name}{String indicating the type of data to obtain.}

\item{...}{NOT USED}
}
\value{
A \code{DataFrame} containing the raw result from CTDdata.
}
\description{
Obtain the raw data from a \code{CTDdata} object, result from a query to
CTDbase.
}
\details{
Available tables are (\code{index_name}):
\enumerate{
  \item \code{"gene interactions"}: (Only for chemicals) Table with
  a relation of the genes interacting with the given chemicals.
  \item \code{"chemical interactions"}: (Only for genes) Table with
  a relation of the chemicals interacting with the given genes.
  \item \code{"diseases"}: Table with a relation of the diseases
  associated with given genes or chemicals.
  \item \code{"gene-gene interactions"}: (Only for genes) Table with
  a relation of the genes interacting with the given genes.
  \item \code{"kegg pathways"}: Table with a relation of the KEGG pathways
  affected by the given chemicals or where the given genes play a role.
  \item \code{"go terms"}: Table with a relation of the GO terms affected by
  the given chemicals or where the given genes play a role.
}
}
\examples{
data("gala")
get_table(gala, "diseases")[1:3, ]
}
