% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllGenerics.R
\name{enrich}
\alias{enrich}
\title{Method to perform enrichment analysis using two \code{CTDdata} objects}
\usage{
enrich(x, y, universe, use = "curated", warnings = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{\link{CTDdata}}.}

\item{y}{Object of class \code{\link{CTDdata}}.}

\item{universe}{Vector of strings corresponding to the genes to be used
as universe.}

\item{use}{(default: \code{"curated"}) It can take values \code{"curated"}
or \code{"all"} to filter or not filter for curated the genes into
the \code{CTDdata} objects.}

\item{warnings}{(default: \code{TRUE}).}

\item{...}{NOT USED}
}
\value{
A list with class \code{htest}. Check
\code{fisher.test} for more information.
}
\description{
This methods performs a fisher test using the genes in two objects of
class \code{\link{CTDdata}}. The object in 'x' is used as source while
the object on 'y' is used as universe. When object 'x' corresponds to
an object created with \code{\link{query_ctd_gene}}, the used genes
are the found terms in CTDbase. In the other cases (chemicals and
disease \code{\link{CTDdata}}), the genes from  the 'gene interactions'
table are used. If \code{universe} is missing, all genes in CTDbase
are used as universe.
}
\examples{
# Example in a tryCatch, since we are performing a connection to a server we might
# get a refused connection due to a server rejection. Evaluate the recieved HTTP 
# message to understand if the server is not available or if your IP adress is temporarly restricted
tryCatch({
data("gala")
air <- query_ctd_chem( terms = "Air Pollutants" )
hgnc_universe <- readRDS(paste0(path.package("CTDquerier"),"/extdata/universe.RDS"))
enrich(gala, air, hgnc_universe)
}, error = function(w){NULL})
}
