% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDist.R
\name{plotDist}
\alias{plotDist}
\title{Plot data distribution histograms}
\usage{
plotDist(countData, ansCount, sampleName, plotDataToPDF = FALSE)
}
\arguments{
\item{countData}{A 
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}}
object from \code{\link{getRegionCounts}} with count data.}

\item{ansCount}{A 
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}}
object from \code{\link{ansTransform}} with anscombe transformed data.}

\item{sampleName}{Name of the sample being plotted.}

\item{plotDataToPDF}{A logical parameter indicating whether to make plots of the
data distribution to a separate PDF file for each sample.
When TRUE, a histogram will be plotted for the data before and after 
transformation. 
When FALSE, no plots will be made. (default: FALSE)}
}
\value{
A list of the histogram of the count data before and after
anscombe transformation if plotDataToPDF == FALSE. 
None if plotDataToPDF == TRUE.
}
\description{
This function is to plot data distribution histogram before
and after anscombe transformation.
}
\examples{
exRange <- GRanges(seqnames=c("chr1","chr2","chr3","chr4"),
ranges=IRanges(start=c(1000,2000,3000,4000),end=c(1500,2500,3500,4500)))
sampleInfo <- read.table(system.file("extdata", "sample_info.txt", 
package="CSSQ",mustWork = TRUE),sep="\\t",header=TRUE)
exCount <- matrix(c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16),nrow=4,ncol=4)
exData <- SummarizedExperiment(assays = list(countData=exCount),
rowRanges=exRange,colData=sampleInfo)
ansExData <- ansTransform(exData)
plotEx <- plotDist(exData,ansExData,"HESC_R1")
plotEx[[1]]
}
