% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCountData.R
\name{loadCountData}
\alias{loadCountData}
\title{Load count data from input file.}
\usage{
loadCountData(countFile, regionBed, sampleInfo)
}
\arguments{
\item{countFile}{A path to file containing the count data for the dataset. 
This should be a tab separated file  sample names as header.}

\item{regionBed}{A bed file containing the list of regions that are being 
analyzed.}

\item{sampleInfo}{Object from \code{\link{preprocessData}} containing sample
information.}
}
\value{
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}}
object containing
the region information,
sample information and the count data.
}
\description{
It converts input count file and a bed file  regions 
into a  \code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}}
object.
}
\examples{
countData <- loadCountData(system.file("extdata", "sample_count_data.txt", 
package="CSSQ",mustWork = TRUE),system.file("extdata", "chr19_regions.bed",
package="CSSQ"),
read.table(system.file("extdata", "sample_info.txt", package="CSSQ",
mustWork = TRUE),
sep="\\t",header=TRUE))
countData
}
