% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_qc.R
\name{plot_bar}
\alias{plot_bar}
\title{Create interactive bar plot}
\usage{
plot_bar(
  count.summary,
  x = "Label",
  y = "GiniIndex",
  title = "sgRNA Read Distribution",
  xlab = NULL,
  ylab = "Gini Index",
  fill = "#E69F00",
  yaxis.addition = 0.05
)
}
\arguments{
\item{count.summary}{data.frame containing the count summary information for each sample.}

\item{x}{Character scalar for column of count.summary to plot along the x-axis.}

\item{y}{Character scalar for column of count.summary to plot along the y-axis.}

\item{title}{Character scalar for title of the plot.}

\item{xlab}{Character scalar for label of the x-axis.}

\item{ylab}{Character scalar for label of the y-axis.}

\item{fill}{Character scalar for bar fill color in hex.}

\item{yaxis.addition}{Numeric scalar for additional space to add to the y-axis.}
}
\value{
An interactive bar chart showing the specified summary information for each sample.
The axis and plot title are editable.
}
\description{
Create an interactive bar plot for specific summary information for each sample in the dataset.
}
\examples{
library(CRISPRball)
count.summ <- read.delim(system.file("extdata", "escneg.countsummary.txt",
    package = "CRISPRball"
), check.names = FALSE)
# Gini Index plot
plot_bar(count.summ)

# Zero count sgRNAs plot
plot_bar(count.summ,
    x = "Label", y = "Zerocounts", title = "Fully Depleted sgRNAs",
    fill = "#394E80", ylab = "Zero Count sgRNAs", yaxis.addition = 10
)
}
\author{
Jared Andrews
}
