% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_median_surv_barplot_f.R
\name{mean_median_surv_barplot_f}
\alias{mean_median_surv_barplot_f}
\title{Mean and Median Survival Bar Plot}
\arguments{
\item{surv_mean_med_data}{:args1 - Predicted Mean median survival time data
for patients}

\item{selected_sample}{:args2 - ID of the sample for which user want to
highlight in the plot.}

\item{font_size}{Numeric: Font size for axis text and labels (default = 8)}

\item{font_color}{Character: Font color for text/labels (default = "black")}

\item{bar_colors}{Named vector: Custom bar colors for highlighted and other patients.
Defaults to:
\code{c("TRUE.Mean" = "red", "TRUE.Median" = "blue",
           "FALSE.Mean" = "lightgray", "FALSE.Median" = "darkgray")}}
}
\value{
A list containing two \code{ggplot} objects:
\itemize{
\item \code{mean_med_all_pat}: Bar plot of mean and median survival
times for
all patients.
\item \code{highlighted_selected_pat}: Bar plot highlighting the selected
patient's
mean and median survival times with distinct colors.
}
}
\description{
This function generate barplots for mean and median survival
of patients. Besides, user can also highlight one specific sample by
providing sample IDs
}
\examples{
data(mean_median_survival_time_data, package = "CPSM")
mean_median_surv_barplot_f(
  surv_mean_med_data =
    mean_median_survival_time_data,
  selected_sample = "TCGA-TQ-A7RQ-01",
  font_size = 10,
  font_color = "darkblue",
  bar_colors = c("TRUE.Mean" = "green", "TRUE.Median" = "purple",
                 "FALSE.Mean" = "lightblue", "FALSE.Median" = "gray70")
)

}
