% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTLR_pred_model_f.R
\name{MTLR_pred_model_f}
\alias{MTLR_pred_model_f}
\title{MTLR Prediction Model Function}
\usage{
MTLR_pred_model_f(
  train_clin_data,
  test_clin_data,
  Model_type,
  train_features_data,
  test_features_data,
  Clin_Feature_List,
  surv_time,
  surv_event,
  nfolds = 5
)
}
\arguments{
\item{train_clin_data}{A data frame containing the clinical data for the
training set.}

\item{test_clin_data}{A data frame containing the clinical data for the
test set.}

\item{Model_type}{An integer indicating the model type:
\itemize{
\item 1: Clinical features model
\item 2: PI score model
\item 3: PI score with Clinical features model
\item 4: selected gene set or clinical with selected gene set based model
}}

\item{train_features_data}{A data frame containing the feature data for the
training set.}

\item{test_features_data}{A data frame containing the feature data for the
test set.}

\item{Clin_Feature_List}{A list of clinical features to be used in the
model.}

\item{surv_time}{A string specifying the name of the survival time column.}

\item{surv_event}{A string specifying the name of the survival event column.}

\item{nfolds}{An integer specifying the number of folds for cross-validation.
Default is \code{5}.}
}
\value{
A list containing the following components:
\item{Model}{The fitted MTLR model.}
\item{Error_matrix}{A matrix of error evaluation metrics ( C-index and MAE)
for training and test sets.}
\item{Survival_predictions}{Predicted survival probabilities, mean survival
times, and median survival times.}
\item{Model_type}{The model type selected by the user.}
}
\description{
This function builds a Multi-Task Logistic Regression (MTLR) survival model
based on clinical or selected feature or their combinations. It can
handle various model types based on user input (e.g., Clinical features
only, Clinical features with PI score, selected genes set).
}
\examples{
# Example usage of the MTLR_pred_model_f function
data(Train_Clin, package = "CPSM")
data(Test_Clin, package = "CPSM")
data(Key_Clin_feature_list, package = "CPSM")
result <- MTLR_pred_model_f(
   train_clin_data = Train_Clin,
   test_clin_data = Test_Clin,
   Model_type = 1,
   train_features_data = Train_Clin,
   test_features_data = Test_Clin,
   Clin_Feature_List = Key_Clin_feature_list,
   surv_time = "OS_month",
   surv_event = "OS",
   nfolds = 5
  )


}
