% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COTAN-estimators.R, R/COTAN-getters.R
\name{ParametersEstimations}
\alias{ParametersEstimations}
\alias{estimateLambdaLinear,COTAN-method}
\alias{estimateLambdaLinear}
\alias{estimateNuLinear,COTAN-method}
\alias{estimateNuLinear}
\alias{estimateDispersionViaSolver,COTAN-method}
\alias{estimateDispersionViaSolver}
\alias{estimateDispersionBisection}
\alias{estimateNuBisection,COTAN-method}
\alias{estimateNuBisection}
\alias{estimateDispersionNuBisection,COTAN-method}
\alias{estimateDispersionNuBisection}
\alias{estimateDispersionNuNlminb,COTAN-method}
\alias{estimateDispersionNuNlminb}
\alias{getNu,COTAN-method}
\alias{getNu}
\alias{getLambda,COTAN-method}
\alias{getLambda}
\alias{getDispersion,COTAN-method}
\alias{getDispersion}
\alias{estimatorsAreReady}
\alias{getNuNormData}
\alias{getLogNormData}
\alias{getNormalizedData}
\alias{getProbabilityOfZero}
\title{Estimation of the \code{COTAN} model's parameters}
\usage{
\S4method{estimateLambdaLinear}{COTAN}(objCOTAN)

\S4method{estimateNuLinear}{COTAN}(objCOTAN)

\S4method{estimateDispersionViaSolver}{COTAN}(
  objCOTAN,
  threshold = 0.001,
  cores = 1L,
  maxIterations = 100L,
  chunkSize = 1024L
)

\S4method{estimateNuBisection}{COTAN}(
  objCOTAN,
  threshold = 0.001,
  cores = 1L,
  maxIterations = 100L,
  chunkSize = 1024L
)

\S4method{estimateDispersionNuBisection}{COTAN}(
  objCOTAN,
  threshold = 0.001,
  cores = 1L,
  maxIterations = 100L,
  chunkSize = 1024L,
  enforceNuAverageToOne = TRUE
)

\S4method{estimateDispersionNuNlminb}{COTAN}(
  objCOTAN,
  threshold = 0.001,
  maxIterations = 50L,
  chunkSize = 1024L,
  enforceNuAverageToOne = TRUE
)

\S4method{getNu}{COTAN}(objCOTAN)

\S4method{getLambda}{COTAN}(objCOTAN)

\S4method{getDispersion}{COTAN}(objCOTAN)

estimatorsAreReady(objCOTAN)

getNuNormData(objCOTAN)

getLogNormData(objCOTAN)

getNormalizedData(objCOTAN, retLog = FALSE)

getProbabilityOfZero(objCOTAN)
}
\arguments{
\item{objCOTAN}{a \code{COTAN} object}

\item{threshold}{minimal solution precision}

\item{cores}{number of cores to use. Default is 1.}

\item{maxIterations}{max number of iterations (avoids infinite loops)}

\item{chunkSize}{number of elements to solve in batch in a single core.
Default is 1024.}

\item{enforceNuAverageToOne}{a Boolean on whether to keep the average \code{nu}
equal to 1}

\item{retLog}{When \code{TRUE} calls \code{\link[=getLogNormData]{getLogNormData()}}, calls \code{\link[=getNuNormData]{getNuNormData()}}}
}
\value{
\code{estimateLambdaLinear()} returns the updated \code{COTAN} object

\code{estimateNuLinear()} returns the updated \code{COTAN} object

\code{estimateDispersionViaSolver()} returns the updated \code{COTAN} object

\code{estimateNuBisection()} returns the updated \code{COTAN} object

\code{estimateDispersionNuBisection()} returns the updated \code{COTAN} object

\code{estimateDispersionNuNlminb()} returns the updated \code{COTAN} object

\code{getNu()} returns the \code{nu} array

\code{getLambda()} returns the \code{lambda} array

\code{getDispersion()} returns the \code{dispersion} array

\code{estimatorsAreReady()} returns a boolean specifying whether all
three arrays are non-empty

\code{getNuNormData()} returns the \eqn{\nu}\emph{-normalized} count
\code{data.frame}

\code{getLogNormData()} returns a \code{data.frame} after applying the formula
\eqn{\log_{10}{(10^4 * x + 1)}} to the raw counts normalized by
\emph{cells-size}

\code{getNormalizedData()} returns a \code{data.frame}

\code{getProbabilityOfZero()} returns a \code{data.frame} with the
probabilities of zero
}
\description{
These functions are used to estimate the \code{COTAN} model's
parameters. That is the average count for each gene (\code{lambda}) the average
count for each cell (\code{nu}) and the \code{dispersion} parameter for each gene to
match the probability of zero.

The estimator methods are named \code{Linear} if they can be calculated as a
linear statistic of the raw data or \code{Bisection} if they are found via a
parallel bisection solver.
}
\details{
\code{estimateLambdaLinear()} does a linear estimation of \code{lambda}
(genes' counts averages)

\code{estimateNuLinear()} does a linear estimation of \code{nu} (normalized
cells' counts averages)

\code{estimateDispersionViaSolver()} estimates the negative binomial
dispersion factor for each gene (\code{dispersion}). Determines the value such
that, for each gene, the probability of zero count matches the number of
observed zeros. It assumes \code{\link[=estimateNuLinear]{estimateNuLinear()}} being already run.

\code{estimateNuBisection()} estimates the \code{nu} vector of a \code{COTAN}
object by bisection. It determines the \code{nu} parameters such that, for each
cell, the probability of zero counts matches the number of observed zeros.
It assumes \code{\link[=estimateDispersionViaSolver]{estimateDispersionViaSolver()}} being already run. Since this
breaks the assumption that the average \code{nu} is one, it is recommended not
to run this in isolation but use \code{\link[=estimateDispersionNuBisection]{estimateDispersionNuBisection()}} instead.

\code{estimateDispersionNuBisection()} estimates the \code{dispersion} and
\code{nu} field of a \code{COTAN} object by running sequentially a bisection for each
parameter.

\code{estimateDispersionNuNlminb()} estimates the \code{nu} and
\code{dispersion} parameters to minimize the discrepancy between the observed
and expected probability of zero. It uses the \code{\link[stats:nlminb]{stats::nlminb()}} solver,
but since the joint parameters have too high dimensionality, it converges
too slowly to be actually useful in real cases.

\code{getNu()} extracts the \code{nu} array (normalized cells' counts
averages)

\code{getLambda()} extracts the \code{lambda} array (mean expression for each
gene)

\code{getDispersion()} extracts the \code{dispersion} array (one value for
each gene)

\code{estimatorsAreReady()} checks whether the estimators arrays
\code{lambda}, \code{nu}, \code{dispersion} are available

\code{getNuNormData()} extracts the \eqn{\nu}\emph{-normalized} count table
(i.e. where each column is divided by \code{nu}) and returns it

\code{getLogNormData()} extracts the \emph{log-normalized} count table (i.e.
where each column is divided by the \code{\link[=getCellsSize]{getCellsSize()}}), takes its \code{log10}
and returns it.

\code{getNormalizedData()} is deprecated: please use \code{\link[=getNuNormData]{getNuNormData()}} or
\code{\link[=getLogNormData]{getLogNormData()}} directly as appropriate

\code{getProbabilityOfZero()} gives for each cell and each gene the
probability of observing zero reads
}
\examples{
data("test.dataset")
objCOTAN <- COTAN(raw = test.dataset)

objCOTAN <- estimateLambdaLinear(objCOTAN)
lambda <- getLambda(objCOTAN)

objCOTAN <- estimateNuLinear(objCOTAN)
nu <- getNu(objCOTAN)

objCOTAN <- estimateDispersionViaSolver(objCOTAN, cores = 6L)
dispersion <- getDispersion(objCOTAN)

objCOTAN <- estimateDispersionNuBisection(objCOTAN, cores = 6L,
                                          enforceNuAverageToOne = TRUE)
nu <- getNu(objCOTAN)
dispersion <- getDispersion(objCOTAN)

nuNorm <- getNuNormData(objCOTAN)

logNorm <- getLogNormData(objCOTAN)

logNorm <- getNormalizedData(objCOTAN, retLog = TRUE)

probZero <- getProbabilityOfZero(objCOTAN)

}
