% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariantScore.R
\name{getVariantScore}
\alias{getVariantScore}
\title{getVariantScore}
\usage{
getVariantScore(
  freq,
  expected.ht.mean,
  expected.dup.ht.mean1,
  expected.dup.ht.mean2,
  sigmoid.c1,
  sigmoid.c2.vector,
  sigmoid.int1,
  sigmoid.int2
)
}
\arguments{
\item{freq}{Variant allele frequency}

\item{expected.ht.mean}{Expected heterozygous SNV/indel allele frequency}

\item{expected.dup.ht.mean1}{Expected heterozygous SNV/indel allele frequency when the variant IS NOT in the same allele than the CNV duplication call}

\item{expected.dup.ht.mean2}{Expected heterozygous SNV/indel allele frequency when the variant IS in the same allele than the CNV duplication call}

\item{sigmoid.c1}{Sigmoid c1 parameter}

\item{sigmoid.c2.vector}{Vector containing sigmoid c2 parameters for the six sigmoids functions}

\item{sigmoid.int1}{Sigmoid int 1}

\item{sigmoid.int2}{Sigmoid int 2}
}
\value{
variant score in the [-1, 1] range
}
\description{
Returns score for a given allele frequency
}
\details{
Returns a value between -1 and 1. If the allele frequency increases the
evidence of discarding a CNV, then the score is positive. If the allele
frequency decreases the evidence for discarding a CNV, the score is negative.

The model is based on the fuzzy logic and the score is calculated
using sigmoids. See the vignette to get more details.
}
