% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatasetGenerator.R
\name{simulate_generator}
\alias{simulate_generator}
\title{Create datasets from generators}
\usage{
simulate_generator(
  generator,
  time_ticks,
  times,
  starting_label = "Clonal",
  by = "labels",
  mode = "full"
)
}
\arguments{
\item{generator}{a generator}

\item{time_ticks}{number of steps (updates) of the DTMC associated to the generato}

\item{times}{number of sumlated cells}

\item{starting_label}{node from which to start the simulation}

\item{by}{"labels" or "samples" to use gene labels or sample labels as references to identify the `starting_label`'s node}

\item{mode}{"full" to generate a matrix with `times` genotypes, "compacted" to *efficiently* create an already compacted dataset 
(a dataset showing the genotypes and their respective frequencies)}
}
\value{
the simulated dataset
}
\description{
Simulate the DTMC associated to the generator to create a dataset
that reflects the genotypes of `times` cells, sampled after
`time_ticks` passages.
}
\examples{
require(dplyr)

example_dataset() \%>\%
  make_generator_stub() \%>\% 
  set_generator_edges(
    list(
      "D", "A, D", 1 , 
      "A", "A, D", 1 , 
      "A, D", "A, C, D", 1 , 
      "A, D", "A, B, D", 1 , 
      "Clonal", "D", 1 , 
      "Clonal", "A", 1 , 
      "D", "D", 1 , 
      "A", "A", 1 , 
      "A, D", "A, D", 1 , 
      "A, C, D", "A, C, D", 1 , 
      "A, B, D", "A, B, D", 1 , 
      "Clonal", "Clonal", 1 
  )) \%>\% 
  finalize_generator \%>\% 
  simulate_generator(3, 10)

}
