% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{dataset_preprocessing_population}
\alias{dataset_preprocessing_population}
\title{Run CIMICE preprocessing for poulation format dataset}
\usage{
dataset_preprocessing_population(compactedDataset)
}
\arguments{
\item{compactedDataset}{a list (matrix: a mutational matrix, 
counts: number of samples with given genotype). 
"counts" is normalized automatically.}
}
\value{
a list containing the mutational matrix ("samples"),
the mutational frequencies of the genotypes ("freqs"),
the node labels ("labels") and finally the gene names ("genes")
}
\description{
executes the preprocessing steps of CIMICE
}
\details{
Preprocessing steps:

1) genotype frequencies are computed

2) labels are prepared
}
\examples{
require(dplyr)
example_dataset_withFreqs() \%>\% dataset_preprocessing_population

}
