% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{build_subset_graph}
\alias{build_subset_graph}
\title{Remove transitive edges and prepare graph}
\usage{
build_subset_graph(edges, labels)
}
\arguments{
\item{edges}{edge list, built from "build_topology_subset"}

\item{labels}{list of node labels, to be paired with the graph}
}
\value{
a graph with the subset topology, omitting transitive edges
}
\description{
Create a graph from the "build_topology_subset" edge list, so
that it respects the subset relation, omitting the transitive edges.
}
\examples{
require(dplyr)
preproc <- example_dataset() \%>\% dataset_preprocessing
samples <- preproc[["samples"]]
freqs   <- preproc[["freqs"]]
labels  <- preproc[["labels"]]
genes   <- preproc[["genes"]]
edges <- build_topology_subset(samples)
g <- build_subset_graph(edges, labels)

}
