% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils_CHETAH.R
\name{Classify}
\alias{Classify}
\title{(Re)classify after running \code{\link{CHETAHclassifier}} using a confidence threshold \cr
NOTE: In case of bulk reference profiles: only the correlations will be used,
as the data does not allow for profile or confidence scores to be calculated.}
\usage{
Classify(input, thresh = 0.1, return_clas = FALSE)
}
\arguments{
\item{input}{a SingleCellExperiment on which \code{\link{CHETAHclassifier}} has been run}

\item{thresh}{a confidence threshold between -0 and 2. \cr
Selecting 0 will classify all cells, whereas 2 will result i
n (almost) no cells to be classified. \cr
\emph{recommended}: between 0.1 (fairly confident) and 1 (very confident)}

\item{return_clas}{Instead of returning the SingleCellExperiment, only return the classification vector}
}
\value{
a charachter vector of the cell types with the names of the cells
}
\description{
(Re)classify after running \code{\link{CHETAHclassifier}} using a confidence threshold \cr
NOTE: In case of bulk reference profiles: only the correlations will be used,
as the data does not allow for profile or confidence scores to be calculated.
}
\examples{
data('input_mel')
data('headneck_ref')
## Classify all cells
input_mel <- Classify(input_mel, 0)

## Classify only cells with a very high confidence
input_mel <- Classify(input_mel, 1)

## Back to the default
input_mel <- Classify(input_mel)

## Return only the classification vector
celltypes <- Classify(input_mel, 1, return_clas = TRUE)
}
